"""
Script for training LAMBO models using UD data
"""
import importlib_resources as resources
from pathlib import Path

from lambo.learning.train import train_new_and_save

if __name__=='__main__':
    treebanks = Path.home() / 'PATH-TO/ud-treebanks-v2.9/'
    outpath = Path.home() / 'PATH-TO/models/'
    # Read available languages
    languages_file_str = resources.read_text('lambo.resources', 'languages.txt', encoding='utf-8', errors='strict')
    languages = [line.split(' ')[0] for line in languages_file_str.split('\n')]
    
    for i in range(len(languages)):
        language = languages[i]
        if (outpath / (language + '.pth')).exists():
            continue
        print(str(i) + '/' + str(len(languages)) + '========== ' + language + ' ==========')
        inpath = treebanks / language
        train_new_and_save('LAMBO-BILSTM', inpath, outpath)
