"""
Script for training LAMBO models using UD data from pretrained
"""

from pathlib import Path

import importlib_resources as resources

from lambo.learning.train import train_new_and_save, train_pretrained_and_save

if __name__=='__main__':
    treebanks = Path.home() / 'PATH-TO/ud-treebanks-v2.9/'
    outpath = Path.home() / 'PATH-TO/models/full/'
    pretrained_path = Path.home() / 'PATH-TO/models/pretrained/'
    
    languages_file_str = resources.read_text('lambo.resources', 'languages.txt', encoding='utf-8', errors='strict')
    lines = [line.strip() for line in languages_file_str.split('\n') if not line[0] == '#']
    
    for i, line in enumerate(lines):
        parts = line.split()
        model = parts[0]
        language = parts[1]
        if (outpath / (model + '.pth')).exists():
            continue
        print(str(i) + '/' + str(len(lines)) + '========== ' + model + ' ==========')
        inpath = treebanks / model
        if language != '?':
            train_pretrained_and_save(language, inpath, outpath, pretrained_path)
        else:
            train_new_and_save('LAMBO-BILSTM', inpath, outpath)
