"""
Short demo on using LAMBO
"""
from lambo.segmenter.lambo import Lambo

if __name__ == '__main__':
    
    # Load the recommended model for Polish
    lambo = Lambo.get('Polish')
    
    # Provide text, including pauses (``(yy)``), emojis and turn markers (``<turn>``).
    text = "Ciemny i jasny (yy) pies biegają 🏴w płytkiej w🅾️dzie... obok 🏴󠁧󠁢󠁷󠁬󠁳󠁿kamienistej😂 plaży.\n\n 😆 To jest następne zdanie <turn>to następna tura."
    
    # Perform segmentation
    document = lambo.segment(text)
    
    # Display the results
    for turn in document.turns:
        print('======= TURN =======')
        print('TEXT: ' + turn.text[:100] + '...')
        for sentence in turn.sentences:
            print('======= SENTENCE =======')
            print('TEXT: "' + sentence.text + '"')
            formatted = ''
            for token in sentence.tokens:
                if token.is_multi_word:
                    formatted += '((' + token.text + '))'
                else:
                    formatted += '(' + token.text + ')'
            print('TOKENS: ' + formatted)
