"""File containing Requester unit tests."""
import os
import pytest
import shutil

from lpmn_client import download_file, download_file_as_dict, upload_file
from lpmn_client import Task


class TestLPMN(object):
    """Unit test class."""

    @pytest.fixture
    def uploaded_file(self):
        """Uploads single file."""
        file_id = upload_file("./tests/example/dir/test1")
        return file_id

    @pytest.fixture
    def uploaded_dir(self):
        """Uploads a directory."""
        file_id = upload_file("./tests/example/dir")
        return file_id

    @pytest.fixture
    def uploaded_zip(self):
        """Uploads a zip file."""
        file_id = upload_file("./tests/example/dir.zip")
        return file_id

    @pytest.mark.parametrize(
        "file_id", ["uploaded_file", "uploaded_dir", "uploaded_zip"]
    )
    def test_download(self, file_id, request):
        """Test downloading of uploaded files."""
        file_id = request.getfixturevalue(file_id)
        path = download_file(file_id, output_path="./out_test")
        assert os.path.isfile(path)

    @pytest.mark.parametrize(
        "file_id", ["uploaded_file", "uploaded_dir", "uploaded_zip"]
    )
    def test_download_file_as_dict(self, file_id, request):
        """Test downloading of uploaded files as dicts."""
        file_id = request.getfixturevalue(file_id)
        data = download_file_as_dict(file_id)
        assert len(data) > 0

    @pytest.mark.parametrize(
        "file_id", ["uploaded_file", "uploaded_dir", "uploaded_zip"]
    )
    def test_query(self, file_id, request):
        """Test query on uploaded files."""
        file_id = request.getfixturevalue(file_id)
        t = Task("any2txt|wcrft2")
        output_file = t.run(file_id)
        path = download_file(output_file, output_path="./out_test")
        assert os.path.isfile(path)

    def teardown_class(self):
        """Teardown class."""
        shutil.rmtree("./out_test")
