import setuptools


with open("README.md", "r") as fh:
    long_description = fh.read()

setuptools.setup(
    name="lpmn_client",
    version="1.4.4",
    author="Szymon Ciombor, Mateusz Gniewkowski",
    author_email="Szymon.Ciombor@pwr.edu.pl, mateusz.gniewkowski@pwr.edu.pl",
    description="Client for writing LPMN queries.",
    long_description=long_description,
    long_description_content_type="text/markdown",
    packages=setuptools.find_packages(exclude="tests"),
    python_requires=">=3.6",
    zip_safe=True,
    entry_points={"console_scripts": ["lpmn_client=lpmn_client.__main__:main"]},
    install_requires=["requests", "pyyaml", "tqdm"],
)
