"""Implementation of mwe service."""
import argparse

from lpmn_client import download_file, upload_file
from lpmn_client import Task


def get_args():
    """Parse arguments."""
    parser = argparse.ArgumentParser(
        description="LPMN CLI tool",
    )

    parser.add_argument(
        "-v",
        "--verbose",
        help="If progress should be printed.",
        action="store_true"
    )
    parser.add_argument(
        "-i",
        "--input",
        help="Path to a input file on local machine."
    )
    parser.add_argument(
        "-o",
        "--output",
        help="Path to a output directory on local machine."
    )
    parser.add_argument(
        "-f",
        "--filename",
        help="Downloaded file name.",
        default=None
    )
    parser.add_argument(
        "lpmn",
        help="LPMN query (e.g. any2txt|wcrft)"
    )
    return parser.parse_args()


def main():
    """Runs the program."""
    args = get_args()
    file_id = upload_file(file_path=args.input)
    t = Task(args.lpmn)
    output_file_id = t.run(file_id=file_id, verbose=args.verbose, timeout=0)
    downloaded = download_file(
        file_id=output_file_id,
        output_path=args.output,
        filename=args.filename
    )
    print(f"Result saved to {downloaded}")


if __name__ == "__main__":
    main()
