  

# LPMN Client

Command line utility for communicating with the LPMN query handler.

## Requirements

*  `python 3.6+`

## Installation and running

  
```
git clone https://gitlab.clarin-pl.eu/nlpworkers/lpmn_client
pip install -r requirements.txt
python -m lpmn_client

```
Alternatively, download using pip:
```
pip install -i https://pypi.clarin-pl.eu lpmn_client
lpmn_client
```

Please follow build-in help to use the tool as a CLI.

## Configuration

Configration file looks as follows:

```
[APP]
base_url = https://ws.clarin-pl.eu/nlprest2/base
output_path = ./out
email = lpmn_client@clarin-eu.pl
```

If file is not specified the above values are used as defaults.
If there is a file named `config.ini` in the same directory program is runned it overrides defaults.
Configuration file can also be stored in  `~/.config/lpmn_client/config.ini` (or in `C:\Users\mfgni\AppData\Roaming\lpmn_client` on Windows). This file has a lower priority than the previous one

User can also override config using enviroment variables:

| env        | matching option |
|------------|-----------------|
| LPMN_EMAIL | email           |
| LPMN_OUT   | output_path     |

## Usage API


```python
from lpmn_client import download_file, upload_file
from lpmn_client import Task

file_id = upload_file("tests/example/dir")
t = Task("any2txt|wcrft2")
output_file_id = t.run(file_id)
downloaded = download_file(output_file_id, "./out")
print(downloaded)
```
(C) CLARIN-PL
