"""Interface for replacers."""

from abc import ABC, abstractmethod
from typing import List, Tuple

from src.detections import Detection


class ReplacerInterface(ABC):
    """Interface for replacers."""

    @abstractmethod
    def replace(
        self, text: str, detections: List[Tuple[int, int, Detection]]
    ) -> Tuple[str, List[Tuple[int, int, Detection]]]:
        """Replace detected entities in text with anonimized version.

        Args:
            text (str): Text to be processed.
            detections (List[Tuple[int, int, str]]): List of detections.

        Returns:
            Tuple[str, List[Tuple[int, int, str]]]: Text with supported entities
            replaced with anonimized version and list of detections that were
            not processed by this replacer.

        """
