"""Module for DeleteReplacer class."""

from typing import List, Tuple

from src.detections import Detection
from src.replacers.interface import ReplacerInterface
from src.string_replacements import replace


class DeleteReplacer(ReplacerInterface):
    """Replacer for deleting detected entities."""

    def replace(
        self, text: str, detections: List[Tuple[int, int, Detection]]
    ) -> Tuple[str, List[Tuple[int, int, Detection]]]:
        """Delete detected entities from text.

        Eg.: His name is Bob -> His name is

        Args:
            text (str): Text to be processed.
            detections (List[Tuple[int, int, str]]): List of detections.

        Returns:
            Tuple[str, List[Tuple[int, int, str]]]: Text with supported entities
            replaced with anonimized version and list of detections that were
            not processed by this replacer.

        """
        result = [(start, end, "") for start, end, _ in detections]

        return replace(text, result), []
