from abc import ABC, abstractmethod

from sziszapangma.integration.record_id_iterator import RecordIdIterator
from sziszapangma.integration.repository.experiment_repository import ExperimentRepository


class ProcessingTask(ABC):
    _require_update: bool
    _task_name: str

    def __init__(self, task_name: str, require_update: bool):
        self._require_update = require_update
        self._task_name = task_name

    @abstractmethod
    def run_single_process(self, record_id: str, experiment_repository: ExperimentRepository):
        pass

    @abstractmethod
    def skip_for_record(self, record_id: str, experiment_repository: ExperimentRepository) -> bool:
        pass

    def process(
        self, record_id_iterator: RecordIdIterator, experiment_repository: ExperimentRepository
    ):
        records_ids = list(record_id_iterator.get_all_records())
        for record_index in range(len(records_ids)):
            part = f"{record_index + 1} / {len(records_ids)}"
            record_id = records_ids[record_index]
            skip = self.skip_for_record(
                record_id=record_id, experiment_repository=experiment_repository
            )
            base_log = f"{self._task_name} processing {part} {record_id}"
            if not skip or self._require_update:
                print(base_log)
                self.run_single_process(record_id, experiment_repository)
            else:
                print(f"{base_log} -- skipped")
