from sziszapangma.integration.gold_transcript_processor import GoldTranscriptProcessor
from sziszapangma.integration.repository.experiment_repository import ExperimentRepository
from sziszapangma.integration.task.processing_task import ProcessingTask


class GoldTranscriptTask(ProcessingTask):
    _gold_transcript_processor: GoldTranscriptProcessor
    _gold_transcript_property_name: str

    def __init__(
        self,
        task_name: str,
        gold_transcript_processor: GoldTranscriptProcessor,
        gold_transcript_property_name: str,
        require_update: bool,
    ):
        super().__init__(task_name, require_update)
        self._gold_transcript_processor = gold_transcript_processor
        self._gold_transcript_property_name = gold_transcript_property_name

    def skip_for_record(self, record_id: str, experiment_repository: ExperimentRepository) -> bool:
        return experiment_repository.get_property_for_key(
            record_id, self._gold_transcript_property_name
        )

    def run_single_process(self, record_id: str, experiment_repository: ExperimentRepository):
        experiment_repository.update_property_for_key(
            record_id,
            self._gold_transcript_property_name,
            self._gold_transcript_processor.get_gold_transcript(record_id),
        )
