from sziszapangma.integration.asr_processor import AsrProcessor
from sziszapangma.integration.record_path_provider import RecordPathProvider
from sziszapangma.integration.repository.experiment_repository import ExperimentRepository
from sziszapangma.integration.task.processing_task import ProcessingTask


class AsrTask(ProcessingTask):
    _record_path_provider: RecordPathProvider
    _asr_processor: AsrProcessor
    _asr_property_name: str

    def __init__(
        self,
        task_name: str,
        record_path_provider: RecordPathProvider,
        asr_processor: AsrProcessor,
        asr_property_name: str,
        require_update: bool,
    ):
        super().__init__(task_name, require_update)
        self._record_path_provider = record_path_provider
        self._asr_processor = asr_processor
        self._asr_property_name = asr_property_name

    def skip_for_record(self, record_id: str, experiment_repository: ExperimentRepository) -> bool:
        asr_value = experiment_repository.get_property_for_key(record_id, self._asr_property_name)
        return asr_value is not None and "transcription" in asr_value

    def run_single_process(
        self, record_id: str, experiment_repository: ExperimentRepository
    ) -> None:
        file_record_path = self._record_path_provider.get_path(record_id)
        experiment_repository.update_property_for_key(
            record_id, self._asr_property_name, self._asr_processor.call_recognise(file_record_path)
        )
