from typing import Dict

from sziszapangma.core.alignment.word import Word

_ID = "id"
_VALUE = "value"


class WordMapper:
    @staticmethod
    def to_json_dict(word: Word) -> Dict[str, str]:
        return {_ID: word.id, _VALUE: word.value}

    @staticmethod
    def from_json_dict(input_json_dict: Dict[str, str]) -> Word:
        return Word(input_json_dict[_ID], input_json_dict[_VALUE])
