from typing import Dict

from sziszapangma.core.alignment.step_words import StepWords
from sziszapangma.integration.mapper.word_mapper import WordMapper


class StepWordsMapper:
    @staticmethod
    def to_json_dict(step_words: StepWords) -> Dict[str, any]:
        to_return = dict()
        if step_words.hypothesis_word is not None:
            to_return["hypothesis_word"] = WordMapper.to_json_dict(step_words.hypothesis_word)
        if step_words.reference_word is not None:
            to_return["reference_word"] = WordMapper.to_json_dict(step_words.reference_word)
        return to_return

    @staticmethod
    def from_json_dict(input_json_dict: Dict[str, any]) -> StepWords:
        return StepWords(
            None
            if "reference_word" not in input_json_dict
            else WordMapper.from_json_dict(input_json_dict["reference_word"]),
            None
            if "hypothesis_word" not in input_json_dict
            else WordMapper.from_json_dict(input_json_dict["hypothesis_word"]),
        )
