from typing import Dict

from sziszapangma.core.alignment.alignment_step import AlignmentStep
from sziszapangma.core.alignment.step_type import StepType
from sziszapangma.integration.mapper.step_words_mapper import StepWordsMapper


class AlignmentStepMapper:
    @staticmethod
    def to_json_dict(alignment_step: AlignmentStep) -> Dict[str, any]:
        return {
            "step_type": alignment_step.step_type.name,
            "step_words": StepWordsMapper.to_json_dict(alignment_step.step_words),
            "step_cost": alignment_step.step_cost,
        }

    @staticmethod
    def from_json_dict(input_json_dict: Dict[str, any]) -> AlignmentStep:
        return AlignmentStep(
            StepType[input_json_dict["step_type"]],
            StepWordsMapper.from_json_dict(input_json_dict["step_words"]),
            input_json_dict["step_cost"],
        )
