import json
import os

import pika

from new_experiment.pipeline.pipeline_process_spacy_dep_tag_wer import run_spacy_dep_tag_wer_pipeline
from new_experiment.pipeline.pipeline_process_spacy_ner_wer import run_spacy_ner_wer_pipeline
from new_experiment.pipeline.pipeline_process_spacy_pos_wer import run_spacy_pos_wer_pipeline
from new_experiment.pipeline.pipeline_process_word_classic_wer import run_word_wer_classic_pipeline
from new_experiment.pipeline.pipeline_process_word_embedding_wer import run_word_wer_embedding_pipeline


def get_param(name: str, default: str) -> str:
    return os.environ[name] if name in os.environ else default


_RABBIT_URL = get_param('RABBIT_URL',
                        'amqps://rabbit_user:kz6m4972OUHFmtUcPOHx4kF3Lj6yw7lo@rabbit-asr-benchmarks.theliver.pl:5671/')


def main():
    parameters = pika.URLParameters(_RABBIT_URL)
    parameters._heartbeat = 65535
    connection = pika.BlockingConnection(parameters=parameters)
    channel = connection.channel()
    channel.basic_qos(prefetch_count=1)

    queue_name = f'asr_benchmark_experiments'
    for method_frame, properties, body in channel.consume(queue_name):
        print(method_frame, properties, body)
        message_dict = json.loads(body.decode('utf-8'))
        print(message_dict)

        task = message_dict['task']
        dataset = message_dict['dataset']
        asr_name = message_dict['asr_name']
        if task == 'run_word_wer_classic_pipeline':
            run_word_wer_classic_pipeline(dataset, asr_name)
        elif task == 'run_word_wer_embedding_pipeline':
            run_word_wer_embedding_pipeline(dataset, asr_name)
        elif task == 'run_spacy_dep_tag_wer_pipeline':
            run_spacy_dep_tag_wer_pipeline(dataset, asr_name)
        elif task == 'run_spacy_ner_wer_pipeline':
            run_spacy_ner_wer_pipeline(dataset, asr_name)
        elif task == 'run_spacy_pos_wer_pipeline':
            run_spacy_pos_wer_pipeline(dataset, asr_name)
        else:
            raise Exception(f"Bad message {message_dict}")

        channel.basic_ack(method_frame.delivery_tag)
        print('\n########################################################\n')

    requeued_messages = channel.cancel()
    print('Requeued %i messages' % requeued_messages)
    connection.close()


if __name__ == '__main__':
    main()
