class PropertyHelper:

    @staticmethod
    def get_gold_transcript_words() -> str:
        return 'gold_transcript_words'

    @staticmethod
    def get_gold_transcript_raw() -> str:
        return 'gold_transcript_raw'

    @staticmethod
    def asr_result(asr_name: str) -> str:
        return f'{asr_name}__result'

    @staticmethod
    def pos_alignment(asr_name: str, model_name: str) -> str:
        return f'{asr_name}__{model_name}__pos_alignment'

    @staticmethod
    def pos_metrics(asr_name: str, model_name: str) -> str:
        return f'{asr_name}__{model_name}__pos_metrics'

    @staticmethod
    def dep_tag_alignment(asr_name: str, model_name: str) -> str:
        return f'{asr_name}__{model_name}__dep_tag_alignment'

    @staticmethod
    def dep_tag_metrics(asr_name: str, model_name: str) -> str:
        return f'{asr_name}__{model_name}__dep_tag_metrics'

    @staticmethod
    def ner_alignment(asr_name: str, model_name: str) -> str:
        return f'{asr_name}__{model_name}__ner_alignment'

    @staticmethod
    def ner_metrics(asr_name: str, model_name: str) -> str:
        return f'{asr_name}__{model_name}__ner_metrics'

    @staticmethod
    def word_wer_classic_alignment(asr_name: str) -> str:
        return f'{asr_name}__word_wer_classic_alignment'

    @staticmethod
    def word_wer_classic_metrics(asr_name: str) -> str:
        return f'{asr_name}__word_wer_classic_metrics'

    @staticmethod
    def word_wer_embeddings_alignment(asr_name: str) -> str:
        return f'{asr_name}__word_wer_embeddings_alignment'

    @staticmethod
    def word_wer_embeddings_metrics(asr_name: str) -> str:
        return f'{asr_name}__word_wer_embeddings_metrics'
