from pathlib import Path

from minio import Minio
from urllib3 import HTTPResponse


class MinioAudioRecordRepository:
    _minio: Minio
    _bucket: str

    def __init__(self, minio: Minio, bucket: str):
        self._minio = minio
        self._bucket = bucket

    @staticmethod
    def _get_record_path(dataset_name: str, record_id: str) -> str:
        return f'{dataset_name}/{record_id}.wav'

    def save_file(self, local_path: Path, dataset_name: str, record_id: str):
        self._minio.put_object(self._bucket, self._get_record_path(dataset_name, record_id), open(local_path, 'rb'),
                               len(open(local_path, 'rb').read()))

    def load_file(self, local_path: Path, dataset_name: str, record_id: str):
        record_response: HTTPResponse = self._minio.get_object(self._bucket,
                                                               self._get_record_path(dataset_name, record_id))
        local_path.parent.mkdir(parents=True, exist_ok=True)
        with open(local_path, 'wb') as writer:
            writer.write(record_response.data)
