from minio import Minio
from pymongo import MongoClient

from new_experiment.utils.minio_audio_record_repository import MinioAudioRecordRepository
from sziszapangma.integration.repository.experiment_repository import ExperimentRepository
from sziszapangma.integration.repository.mongo_experiment_repository import MongoExperimentRepository


def get_minio_client() -> Minio:
    return Minio('minio-asr-benchmarks.theliver.pl', 'minio_user', 'eUxzEQbyYPdzrLxuvvethSbk18kB2s7G')


def get_mongo_client() -> MongoClient:
    return MongoClient('mongodb://root:example@mongo-asr-benchmarks.theliver.pl:27021/', ssl=True)


def get_experiment_repository(dataset_name: str) -> ExperimentRepository:
    return MongoExperimentRepository(mongo_client=get_mongo_client(), database_name=dataset_name)


def get_minio_audio_record_repository() -> MinioAudioRecordRepository:
    return MinioAudioRecordRepository(get_minio_client(), 'dataset-audio')
