from pathlib import Path
from typing import Dict, Set

from experiment.dataset_helper import DatasetHelper
from sziszapangma.integration.path_filter import PathFilter
from sziszapangma.integration.record_id_iterator import RecordIdIterator
from sziszapangma.integration.record_path_provider import RecordPathProvider
from sziszapangma.integration.relation_manager_provider import RelationManagerProvider
from sziszapangma.model.relation_manager import RelationManager, FileRelationManager


class VoicelabTelcoRecordProvider(DatasetHelper):
    _path_by_id: Dict[str, str]
    _relation_manager_root_path: str

    def __init__(self, path_filter: PathFilter, relation_manager_root_path: str):
        self._path_by_id = dict({
            self._get_id(it): it
            for it in path_filter.get_list_of_files()
        })
        self._relation_manager_root_path = relation_manager_root_path

    def get_all_records(self) -> Set[str]:
        return set(self._path_by_id.keys())

    def get_path(self, record_id: str) -> str:
        return self._path_by_id[record_id]

    def get_relation_manager(self, record_id: str) -> RelationManager:
        record_path = Path(self._relation_manager_root_path).joinpath(record_id)
        record_path.mkdir(parents=True, exist_ok=True)
        return FileRelationManager(
            str(record_path.joinpath('ab_relations.csv')),
            str(record_path.joinpath('ab_items.json'))
        )

    @staticmethod
    def _get_id(record_file_path: str) -> str:
        path = record_file_path.replace('.wav', '')
        return '__'.join(path.split('/')[-2:])
