import os.path
from typing import List

from experiment.dataset_specific.pl_voicelab_cbiz.voicelab_dependency import get_record_provider
from experiment.dataset_specific.pl_voicelab_cbiz.voicelab_telco_record_provider import VoicelabTelcoRecordProvider
from sziszapangma.model.model import Word
from sziszapangma.model.model_creators import create_new_word, create_new_document
from sziszapangma.model.relation_manager import RelationManager


class VoicelabAdapter:
    _record_provider: VoicelabTelcoRecordProvider

    def __init__(self, record_provider: VoicelabTelcoRecordProvider):
        self._record_provider = record_provider

    @staticmethod
    def save_words(
        words_path: str,
        relation_manager: RelationManager
    ) -> List[Word]:
        with open(words_path, 'r') as f:
            text = f.read()
        words = []
        for single_word in text.split():
            word = create_new_word(text=single_word)
            relation_manager.save_item(word)
            words.append(word)
        document = create_new_document([word['id'] for word in words])
        relation_manager.save_item(document)
        for word in words:
            relation_manager.save_relation(word, document)
        return words

    def import_record(self, record_id: str):
        print(f'record {record_id}')
        relation_manager = self._record_provider.get_relation_manager(record_id)
        relation_manager.clear_all()
        root_path = '/home/marcinwatroba/PWR_ASR/asr-benchmarks/experiment_data/dataset/pl_voicelab_cbiz'

        words_path = [path for path in [
            f'{root_path}/{record_id.replace("__", "/")}.txt',
            f'{root_path}/{record_id.replace("__", "/")}.asr'
        ] if os.path.exists(path)][0]

        self.save_words(words_path, relation_manager)
        relation_manager.commit()


if __name__ == '__main__':
    voicelab_record_provider = get_record_provider()
    adapter = VoicelabAdapter(voicelab_record_provider)
    for it in voicelab_record_provider.get_all_records():
        adapter.import_record(it)
