from experiment.hf_dataset_helper.hf_gold_transcript_processor import HfGoldTranscriptProcessor
from experiment.const_pipeline_names import GOLD_TRANSCRIPT
from experiment.dataset_specific.pl_minds14.dependency_helper import get_record_provider, get_repository
from sziszapangma.integration.experiment_manager import ExperimentManager
from sziszapangma.integration.task.gold_transcript_task import GoldTranscriptTask


def run_voicelab_experiment():
    record_provider = get_record_provider()
    experiment_processor = ExperimentManager(
        record_id_iterator=record_provider,
        processing_tasks=[
            GoldTranscriptTask(
                task_name='gold_transcript_task',
                gold_transcript_processor=HfGoldTranscriptProcessor(record_provider),
                gold_transcript_property_name=GOLD_TRANSCRIPT,
                require_update=False
            )
        ],
        experiment_repository=get_repository(),
        relation_manager_provider=record_provider
    )
    experiment_processor.process()


def example_run():
    run_voicelab_experiment()


if __name__ == '__main__':
    example_run()
