from experiment.luna.pipeline.dependency_provider import get_record_provider, GOLD_TRANSCRIPT, TECHMO_POLISH_ASR, \
    get_multiple_files_repository, \
    GOLD_TRANSCRIPT_SPACY, POS_TECHMO_ALIGNMENT_WER, POS_TECHMO_METRICS_WER, WORD_TECHMO_METRICS_WER, \
    WORD_TECHMO_ALIGNMENT_WER, TECHMO_SPACY, WORD_TECHMO_METRICS_WER_EMBEDDINGS, WORD_TECHMO_ALIGNMENT_WER_EMBEDDINGS, \
    AJN_SPACY, TAG_SPACY_TECHMO_ALIGNMENT_WER_EMBEDDINGS, TAG_SPACY_TECHMO_METRICS_WER_EMBEDDINGS, \
    TAG_SPACY_AJN_METRICS_WER_EMBEDDINGS, TAG_SPACY_AJN_ALIGNMENT_WER_EMBEDDINGS, \
    NER_SPACY_TECHMO_METRICS_WER_EMBEDDINGS, NER_SPACY_TECHMO_ALIGNMENT_WER_EMBEDDINGS, AJN_POLISH_ASR, \
    NER_SPACY_AJN_ALIGNMENT_WER_EMBEDDINGS, NER_SPACY_AJN_METRICS_WER_EMBEDDINGS
from experiment.pos_processing.asr_spacy_token_pos_processing_task import AsrSpacyTokenPosProcessingTask
from experiment.pos_processing.ner_spacy_wer_processing_task import NerSpacyWerProcessingTask
from experiment.pos_processing.spacy_pos_wer_processing_task import SpacyPosWerProcessingTask
from experiment.pos_processing.tag_spacy_wer_processing_task import TagSpacyWerProcessingTask
from sziszapangma.core.transformer.web_embedding_transformer import WebEmbeddingTransformer
from sziszapangma.integration.asr_processor import AsrPathCacheClient
from sziszapangma.integration.experiment_manager import ExperimentManager
from sziszapangma.integration.task.asr_task import AsrTask
from sziszapangma.integration.task.classic_wer_metric_task import ClassicWerMetricTask
from sziszapangma.integration.task.embedding_wer_metrics_task import EmbeddingWerMetricsTask


def run_luna_experiment():
    record_provider = get_record_provider()
    experiment_processor = ExperimentManager(
        record_id_iterator=record_provider,
        processing_tasks=[
            NerSpacyWerProcessingTask(
                task_name='techmo_ner_wer_processing',
                require_update=False,
                gold_transcript_property_name=GOLD_TRANSCRIPT,
                asr_transcript_property_name=TECHMO_POLISH_ASR,
                ner_alignment_wer=NER_SPACY_TECHMO_METRICS_WER_EMBEDDINGS,
                ner_metrics_wer=NER_SPACY_TECHMO_ALIGNMENT_WER_EMBEDDINGS
            ),
            NerSpacyWerProcessingTask(
                task_name='ajn_ner_wer_processing',
                require_update=False,
                gold_transcript_property_name=GOLD_TRANSCRIPT,
                asr_transcript_property_name=AJN_POLISH_ASR,
                ner_alignment_wer=NER_SPACY_AJN_ALIGNMENT_WER_EMBEDDINGS,
                ner_metrics_wer=NER_SPACY_AJN_METRICS_WER_EMBEDDINGS
            )
        ],
        experiment_repository=get_multiple_files_repository(),
        relation_manager_provider=record_provider
    )
    experiment_processor.process()


if __name__ == '__main__':
    run_luna_experiment()
