from experiment.dataset_specific.pl_luna.pipeline.dependency_provider import get_record_provider, get_multiple_files_repository
from experiment.dataset_specific.pl_luna.pipeline.task.luna_gold_transcript_processor import LunaGoldTranscriptProcessor
from sziszapangma.integration.experiment_manager import ExperimentManager
from sziszapangma.integration.task.gold_transcript_task import GoldTranscriptTask
from experiment.const_pipeline_names import GOLD_TRANSCRIPT


def run_luna_experiment():
    record_provider = get_record_provider()
    ExperimentManager(
        record_id_iterator=record_provider,
        processing_tasks=[
            GoldTranscriptTask(
                task_name='gold_transcript_task',
                gold_transcript_processor=LunaGoldTranscriptProcessor(record_provider),
                gold_transcript_property_name=GOLD_TRANSCRIPT,
                require_update=False
            )
        ],
        experiment_repository=get_multiple_files_repository(),
        relation_manager_provider=record_provider
    ).process()


if __name__ == '__main__':
    run_luna_experiment()
