from experiment.dataset_specific.pl_luna.luna_record_provider import LunaRecordProvider
from sziszapangma.integration.path_filter import ExtensionPathFilter
from sziszapangma.integration.repository.multi_files_experiment_repository import MultiFilesExperimentRepository

LUNA_DIRECTORY = 'experiment_data/dataset/pl_luna'


def get_record_provider() -> LunaRecordProvider:
    return LunaRecordProvider(
        ExtensionPathFilter(
            root_directory=f'{LUNA_DIRECTORY}/LUNA.PL',
            extension='wav'
        ),
        relation_manager_root_path='experiment_data/dataset_relation_manager_data/pl_luna'
    )


def get_multiple_files_repository() -> MultiFilesExperimentRepository:
    return MultiFilesExperimentRepository('experiment_data/pipeline', 'pl_luna')
