import pathlib

import numpy as np

from scipy.io.wavfile import write as write_wav

from experiment.experiment_dependency_provider import get_record_provider

if __name__ == '__main__':
    dataset = get_record_provider('pl_google_fleurs').get_dataset()
    pathlib.Path('experiment_data/dataset/pl_google_fleurs/audio').mkdir(parents=True, exist_ok=True)
    index = 0
    ds_size = len(dataset)
    for it in dataset:
        index += 1
        print(f'pl_google_fleurs save wave {index} / {ds_size}')
        it_id = it['audio']['path']
        path = f'experiment_data/dataset/pl_google_fleurs/audio/{it_id}'
        arr = (it['audio']['array'] * 32768).astype(np.int16)
        write_wav(path, it['audio']['sampling_rate'], arr)
