from experiment.google_fleurs.dependency_helper import get_record_provider, GOLD_TRANSCRIPT, GOLD_TRANSCRIPT_SPACY, \
    get_repository
from experiment.hf_dataset_helper.hf_gold_transcript_processor import HfGoldTranscriptProcessor
from experiment.pos_processing.gold_transcript_spacy_token_pos_processing_task import \
    GoldTranscriptSpacyTokenPosProcessingTask
from sziszapangma.integration.experiment_manager import ExperimentManager
from sziszapangma.integration.task.gold_transcript_task import GoldTranscriptTask


def run_voicelab_experiment():
    record_provider = get_record_provider()
    experiment_processor = ExperimentManager(
        record_id_iterator=record_provider,
        processing_tasks=[
            GoldTranscriptTask(
                task_name='gold_transcript_task',
                gold_transcript_processor=HfGoldTranscriptProcessor(record_provider),
                gold_transcript_property_name=GOLD_TRANSCRIPT,
                require_update=False
            ),
            GoldTranscriptSpacyTokenPosProcessingTask(
                task_name='gold_transcript_spacy_task',
                input_property_name=GOLD_TRANSCRIPT,
                spacy_property_name=GOLD_TRANSCRIPT_SPACY,
                require_update=True
            )
        ],
        experiment_repository=get_repository(),
        relation_manager_provider=record_provider
    )
    experiment_processor.process()


def example_run():
    run_voicelab_experiment()


if __name__ == '__main__':
    example_run()
