# coding: utf8

# Copyright (C) 2017 Michał Kaliński
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Sorting keys that provide locale-dependant alphabetical sorting."""

from __future__ import absolute_import, division


import locale

import six


__all__ = 'text_key',


if six.PY2:
    # Since Python 2 does not support strxfrm for unicode, encode it in UTF-8
    # before transforming.
    def text_key(text):
        return locale.strxfrm(text.encode('UTF-8'))
else:
    text_key = locale.strxfrm
