# coding: utf8

# Copyright (C) 2017 Michał Kaliński
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from __future__ import absolute_import, division


from six.moves import range


__all__ = 'RelationInfoTuple',


class RelationInfoTuple(tuple):
    """Tuple subclass for :class:`~plwn.bases.RelationInfoBase` instances.

    Meant as return value for ``relations`` properties.

    Overrides search methods to use :meth:`~plwn.bases.RelationInfoBase.eqv`
    for membership testing, to make checking if a synset / unit has some
    relation easier.
    """

    __slots__ = ()

    def __repr__(self):
        return (
            self.__class__.__name__ +
            super(RelationInfoTuple, self).__repr__()
        )

    def __contains__(self, item):
        return any(rel.eqv(item) for rel in self)

    def index(self, x, i=None, j=None):
        rend = min(j, len(self)) if j is not None else len(self)

        for ind in range(i or 0, rend):
            if self[ind].eqv(x):
                return ind

        raise ValueError(repr(x) + ' not in tuple')

    def count(self, x):
        cnt = 0

        for rel in self:
            if rel.eqv(x):
                cnt += 1

        return cnt
