"""Implementation of download method."""
import os
import requests
from six.moves import configparser

config = configparser.ConfigParser()
config_path = os.path.join(os.path.dirname(
    os.path.abspath(__file__)), "config.ini")
config.read(config_path)


def download(name="default_model"):
    url = config["DOWNLOAD"][name]
    r = requests.get(url)
    with open(name, "wb") as f:
        f.write(r.content)
        f.close()
    return
