# coding: utf8

# Copyright (C) 2017 Michał Kaliński
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from __future__ import absolute_import, division


import pkg_resources as pkgr


__all__ = 'get_default_load_args',


_DEFAULT_LOC = 'plwn.default', 'plwn-3.0-v5.db'
_DEFAULT_FORMAT = 'sqlite3'


def get_default_load_args():
    """Get a tuple with arguments to :func:`~plwn._loading.load`.

    Required to load the default storage.

    This is a helper function meant to be internally used by
    :func:`~plwn._loading.load_default`.

    **Advanced note:** This function refers to the bundled file using
    ``pkg_resources.resource_filename()``. Normally, the ``plwn`` package will
    not be installed as a zipfile, but if you override this, then if you use
    this function you will have to call ``pkg_resources.cleanup_resources()``
    before the process exits.
    """
    storage_filename = pkgr.resource_filename(*_DEFAULT_LOC)
    return storage_filename, _DEFAULT_FORMAT
