# coding: utf8

# Copyright (C) 2017 Michał Kaliński
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

from ._loading import load_default
from ._loading import read
from ._loading import load
from ._loading import show_source_formats
from ._loading import show_storage_formats
from .download import download
# Import the enums that are needed for selecting and filtering
from .enums import PoS, RelationKind

# Setup logging for the package (not)
import logging as _logging
_logging.getLogger('plwn').addHandler(_logging.NullHandler())

__all__ = [
    "PoS",
    "read",
    "load",
    "show_storage_formats",
    "show_source_formats",
    "load_default",
    "RelationKind",
    "download",
]
