function setup_entries_list(options) {
    const can_see_assignees = has_permission("users.view_assignment");

    function is_assigned_to_user_renderer (data) {
        return (
            data
            && data.lexical_units
            && data.lexical_units.some(lu => lu.assignee_username === window.USER_USERNAME && lu.status == 'O')
        ) ? gettext("tak") : gettext("nie");
    }

    var datatable = setup_datatable({
        element: options.table,
        selectFirst: true,
        url: '/' + window.lang + '/entries/get_entries/?with_lexical_units=true',
        columns: [
            { data: 'lemma' },
            { data: 'POS' },
            { render: data => (data && data.lexical_units && data.lexical_units.some(lu => lu.assignee_username !== null)) ? gettext("nie") : gettext("tak") },
            can_see_assignees ? { data: 'assignee_username' } : { render: is_assigned_to_user_renderer },
        ]
    });
    datatable.on('click', 'tr.entry', function () {
        var row = datatable.row(this);
        var has_drilldown = row.child.isShown();
        $('.drilldown:visible', options.table).each(function () { datatable.row($(this).data("row")).child.hide(); });
        if (!has_drilldown) {
            if (!row.data()) return;
            var drilldown = $("<div>").addClass("drilldown").data("row", this);
            row.child(drilldown).show();
            setup_lexical_units_table(drilldown, row.data().lexical_units, can_see_assignees, options);
            drilldown.closest("td").addClass("p-0 pl-4");
        }
    });
}

function setup_lexical_units_table(drilldown, lexical_units, can_see_assignees, options) {
    if (!lexical_units.length) {
        return '';
    }

    function get_lexical_unit_row(lexical_unit) {
        const is_assigned_to_user = lexical_unit.assignee_username === window.USER_USERNAME;
        return $(`
            <tr class="lexical-unit">
                <td class="p-1">${lexical_unit.display}</td>
                <td class="p-1">${lexical_unit.status}</td>
                ` + (
                    can_see_assignees
                        ? `<td class="p-1">${lexical_unit.assignee_username || ""}</td>`
                        : `<td class="p-1">${is_assigned_to_user ? gettext("tak") : gettext("nie")}</td>`
                ) + `
            </tr>
        `).click(function () {
            $(this).addClass('table-primary').siblings().removeClass("table-primary");
            options.lexicalUnitSelected($(drilldown.data("row")).data("entry"), lexical_unit.pk);
        });
    }
    var table = $(`
        <table class="table">
            <thead>
                <tr>
                    <th class="p-1">${gettext("Jednostka Leksykalna")}</th>
                    <th class="p-1">${gettext("Status")}</th>
                    ` + (
                        can_see_assignees
                            ? `<th class="p-1">${gettext("Leksykograf")}</th>`
                            : `<th class="p-1">${gettext("Moje")}</th>`
                    ) + `
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    `);
    drilldown.append(table);
    lexical_units.map(function (lexical_unit) {
        $("tbody", table).append(get_lexical_unit_row(lexical_unit));
    });
}

function setup_notes($container, $template, pk, model, refreshFunction) {
    $container.html($template.children().clone());
    $('.show-note-form', $container).click(function () {
        $('.note-form', $container).html($('#note-form-template > div', $container).clone());
        $('.hide-note-form', $container).click(function () { $('.note-form', $container).html(''); });
        $('.add-note', $container).click(function () {
            $.ajax({
                type     : 'post',
                url      : $('#note-form-template').data('url').replace('MODEL', model).replace('PK', pk),
                dataType : 'json',
                data     : { note: $('.note-form textarea[name=note]').val() },
                timeout  : 5000,
                success  : function (response) {
                    refreshFunction();
                },
                error    : function () {
                    alert(gettext('Nie udało się dodać notatki.'));
                }
            });
        });
        return false
    });
    $.ajax({
        type: 'get',
        url: $('.notes-table').data('url').replace('MODEL', model).replace('PK', pk),
        success: function (data) {
            data.notes.map(function (note) {
                $('.notes-table tbody', $container).append(`<tr><td>${note.note}</td><td>${note.owner_label}</td></tr>`);
            });
        }
    })
}
