import UnificationEntriesForFramesList from "./UnificationEntriesForFramesList.js";
import UnificationEntriesList from "./UnificationEntriesList.js";
import UnificationFramesList from "./UnificationFramesList.js";

export default {
  props: {
    initialLexicalUnitId: Number,
    initialEntryId: Number,
  },
  data () {
    return {
      gettext: window.gettext,
      isFrameView: false
    }
  },
  emits: ['lexicalUnitSelected', 'unifiedFrameSelected'],
  methods: {
    lexicalUnitSelected (entryId, lexicalUnitId) {
      this.$emit('lexicalUnitSelected', entryId, lexicalUnitId);
    },
    unifiedFrameSelected (unifiedFrameId) {
      this.$emit('unifiedFrameSelected', unifiedFrameId);
    }
  },
  components: {UnificationEntriesList, UnificationEntriesForFramesList, UnificationFramesList},
  template: `
    <label class="float-left mt-2"><input type="checkbox" v-model="isFrameView" /> {{ gettext('RAMY') }}</label>
    <div v-if="!isFrameView"><unification-entries-for-frames-list :initialLexicalUnitId="initialLexicalUnitId" :initialEntryId="initialEntryId" @unified-frame-selected="unifiedFrameSelected" /></div>
    <div v-else><unification-frames-list @unified-frame-selected="unifiedFrameSelected" /></div>
  `
};
