import Spinner from './Spinner.js';

export default {
  components: { Spinner },
  props: {
    entryId: Number,
    lexicalUnitId: Number
  },
  data() {
    return { frame: null, unifiedFrame: undefined, gettext: window.gettext, hasPermission: window.has_permission }
  },
  emits: ['refresh'],
  methods: {
    goToEdit (unifiedFrameId, entryId, lexicalUnitId) {
      window.location = `/${lang}/entries/unification?unified_frame_id=${unifiedFrameId}&entry_id=${entryId}&lexical_unit_id=${lexicalUnitId}`;
    },
    markAsInvalid () {
      $.ajax({
        type: 'post',
        url: `/${lang}/semantics/frame_mark_as_invalid/${this.frame.id}/`,
        dataType: 'json',
        timeout: 60000,
      }).then(() => { this.$emit('refresh'); });
    },
    take () {
      $.ajax({
        type     : 'post',
        url      : `/${lang}/unifier/frame_assign/${this.lexicalUnitId}/`,
        dataType : 'json',
        timeout  : 60000,
        success: function (response) {
          show_info('Rama została stworzona oraz przypisana użytkownikowi.');
          this.goToEdit(response.unified_frame_id, this.entryId, this.lexicalUnitId);
        }.bind(this),
        error: function (request, errorType, errorMessage) {
          show_error(errorType + ' (' + errorMessage + ')');
        }
      });
    },
    confirmInvalid () {
      $.ajax({
        type: 'post',
        url: `/${lang}/semantics/frame_confirm_invalid/${this.frame.id}/`,
        dataType: 'json',
        timeout: 60000,
      }).then(() => { this.$emit('refresh'); });
    },
    rejectInvalid () {
      $.ajax({
        type: 'post',
        url: `/${lang}/semantics/frame_reject_invalid/${this.frame.id}/`,
        dataType: 'json',
        timeout: 60000,
      }).then(() => { this.$emit('refresh'); });
    },
    isReadyToProcess () {
      return (!this.isLeksykograf() && this.unifiedFrame?.status === 'G') || (this.isLeksykograf() && this.frame?.status === 'O');
    },
    isReadyToGet () {
      return this.isLeksykograf() && this.frame?.status === 'N';
    },
    isLeksykograf () {
      return !has_permission("users.view_assignment");
    },
    setup_notes () {
      setup_notes($('#lexical-unit-notes'), $('#lexical-unit-notes-template'), this.lexicalUnitId, 'meanings.LexicalUnit', this.setup_notes);
    },
    setup () {
      $('#lexical-unit-notes').html('');
      get_entry(this.entryId, false, this.lexicalUnitId).then(entry => {
        this.frame = entry.frames[0];
        this.unifiedFrame = entry.unified_frame;
        setup_notes($('#lexical-unit-notes'), $('#lexical-unit-notes-template'), this.lexicalUnitId, 'meanings.LexicalUnit', this.setup_notes);
      });
    }
  },

  // created () {
  //   this.setup();
  // },
  mounted () {
    Split(['#semantics-frames-pane', '#semantics-schemata-pane'], {
      sizes: [40, 60],
      minSize: 400,
      gutterSize: 4,
      elementStyle: (dimension, size, gutterSize) => {
        return {
          'flex-basis': 'calc(' + size + '% - ' + gutterSize + 'px)'
        }
      },
    });
    this.setup();
  },
  template: `
    <div class="col h-100 px-1 pt-0 pb-2 overflow-auto" id="semantics-frames-pane">
      <spinner />
      <div id="semantics-frames"></div>
      <div class="text-center mb-3">
        <div>
          <a class="btn btn-sm btn-outline-dark mr-2" v-if="frame?.status === 'N'" @click="markAsInvalid">{{ !isLeksykograf() ? gettext('Zła') : gettext('Błędna') }}</a>
          <a class="btn btn-sm btn-outline-dark mr-2" v-if="isReadyToGet() && unifiedFrame === null" @click="take">{{ gettext('Pobierz') }}</a>
          <a
            class="btn btn-sm btn-outline-dark mr-2"
            v-if="isReadyToProcess()"
            @click="goToEdit(this.unifiedFrame.pk, this.entryId, this.lexicalUnitId)"
          >
            {{ isLeksykograf() ? gettext('Obrabiaj') : gettext('Sprawdź') }}
          </a>
          <a
            class="btn btn-sm btn-outline-dark mr-2"
            v-if="frame?.status === 'S' && unifiedFrame?.status === 'S'"
            @click="goToEdit(this.unifiedFrame.pk)"
          >
            {{ gettext('Obejrzyj') }}
          </a>
          <a
            class="btn btn-sm btn-outline-dark mr-2"
            v-if="frame?.status === 'B' && hasPermission('semantics.manage_invalid_lexical_units')"
            @click="confirmInvalid"
          >
            {{ gettext('Potwierdź') }}
          </a>
          <a
            class="btn btn-sm btn-outline-dark mr-2"
            v-if="frame?.status === 'B' && hasPermission('semantics.manage_invalid_lexical_units')"
            @click="rejectInvalid"
          >
            {{ gettext('Odrzuć') }}
          </a>
        </div>
<!--        <span v-if="unifiedFrame === null">{{ gettext('Brak ramy unifikacyjnej') }}</span>-->
      </div>
      <div id="lexical-unit-notes"></div>
    </div>
    <div class="col h-100 px-1 pt-0 pb-0 overflow-auto" id="semantics-schemata-pane">
      <div id="semantics-schemata"></div>
    </div>
  `
}
