import InfoTooltip from "../InfoTooltip.js";

export default {
    props: {
        subentries: Object,
        frame: Object,
        alternations: Object,
        realisation_phrases: Object,
        realisation_descriptions: Object,
    },
    components: {InfoTooltip},
    emits: ['schemataSelected'],
    data() {
        return {
            img_prefix: String
        }
    },
    methods: {
        getFunctions(position) {
            const props_spans = [];
            if (position.func.str !== '') {
                props_spans.push({str: position.func.str, tooltip: position.func.desc});
            }
            if (position.control.str !== '') {
                props_spans.push({str: position.control.str, tooltip: position.control.desc});
            }
            if (position.p_control.str !== '') {
                props_spans.push({str: position.p_control.str, tooltip: position.p_control.desc});
            }
            return props_spans;
        },
        getSchemataPositionCnt(schema) {
            return schema.positions.length;
        },
        getRealisationDescriptions(schema) {
            const alternationDescList = [];
            if(this.alternations) {
                const curr_alternations = this.alternations[this.frame.id][schema.id];
                const curr_realisation_descriptions = this.realisation_descriptions[this.frame.id][schema.id];
                for (let i in curr_alternations) {
                    alternationDescList.push(curr_realisation_descriptions[i]);
                }
            }
            return '<i>' + alternationDescList + '</i>';
        },
        getRoleCss(schema, position) {
            const roles = [];
            if(this.alternations) {
                const argumentIdSet = new Set();

                const curr_alternations = this.alternations[this.frame.id][schema.id];
                for (let i in curr_alternations) {
                    const alternation = curr_alternations[i]

                    for (let arg_id in alternation){
                        const phrase_ids = alternation[arg_id];
                        phrase_ids.forEach(phrase_id => {
                            if (phrase_id.startsWith(position.id)) {
                                argumentIdSet.add(arg_id);
                            }
                        });
                    }
                }

                argumentIdSet.forEach(argumentId => {
                    const argument = this.frame.arguments.find(arg => argumentId.endsWith(arg.argument_id));
                    const role = argument.role;
                    roles.push(role);
                });

            }
            return roles;
        },
        getPositionPhrases(schema, position) {
            const phrases = [];
            if(this.alternations) {
                const curr_alternations = this.alternations[this.frame.id][schema.id];
                for (let i in curr_alternations) {
                    const alternation = curr_alternations[i]

                    for (let arg_id in alternation){
                        const phrase_ids = alternation[arg_id];
                        phrase_ids.forEach(phrase_id => {
                            if (phrase_id.startsWith(position.id)) {
                                phrases.push(this.realisation_phrases[arg_id][i][phrase_id]);
                            }
                        });
                    }
                }
            }
            return phrases;
        },
        selectSchema(schema) {
            schema.selected = !schema.selected;
            const selected = [];
            this.subentries.forEach(subentry => {
                subentry.schemata.forEach(s => {
                    if(s.selected) {
                        selected.push(s);
                    }
                });
            });
            this.$emit('schemataSelected', selected);
        }
    },
    mounted () {
        this.img_prefix = window.STATIC_URL;
    },
    template: `
    <div>
      <template v-for="subentry in subentries">
        <div class="subentry">
          <div class="mb-1 sticky-top"><h5 class="bg-dark text-light p-1">{{subentry.str}}</h5></div>
          <template v-for="schema in subentry.schemata">
            <div class="schema mb-3" 
                v-if="alternations[this.frame.id][schema.id]"
                @mouseenter="schema.hover=true"
                @mouseleave="schema.hover=false"
                @click="selectSchema(schema)"
                :class="(schema.selected ? 'active' : schema.hover ? 'bg-highlight' : '')"
            >
              <table class="table m-0 table-borderless border border-secondary text-dark">
                  <tbody>
                      <tr class="opinion-row">
                          <th scope="row" class="py-2 px-1 text-secondary" style="width: 3em;">Opinia</th>
                          <td class="opinion-cell py-2 px-1" :colspan="getSchemataPositionCnt(schema)"><img
                                  :src="img_prefix + 'entries/img/' + schema.opinion_key + '.svg'" width="12"
                                  height="12" :alt="schema.opinion"> {{schema.opinion}}
                          </td>
                      </tr>
                      
                      <tr>
                          <th scope="row" class="py-2 px-1 text-secondary">Funkcja</th>
                          
                          <td class="position py-2 px-1 border-top border-left border-secondary"
                            v-for="position in schema.positions">
                            <div v-for="f in getFunctions(position)" class="phrase px-1 py-2">
                                <info-tooltip :text="f.tooltip" :visibleText="f.str"/>
                            </div>
                          </td>
                          
                      </tr>
                      
                      <tr class="realisation-description">
                          <td class="px-1 py-2" :colspan="getSchemataPositionCnt(schema)" v-html="getRealisationDescriptions(schema)"></td>
                      </tr>
                      <tr class="phrase-types alt-0">
                          <th scope="row" class="py-0 px-1 text-secondary">Typy fraz</th>
                          <td v-for="position in schema.positions" class="px-0 py-0 border-top border-left border-secondary">
                              <div v-for="phrase in position.phrases" class="phrase px-1 py-2"
                                      :class="getRoleCss(schema, position)">
                                      <info-tooltip :text="phrase.desc" :visibleText="phrase.str"/>
                              </div>
                              <div v-for="phrase in getPositionPhrases(schema, position)" class="realisation-phrase px-1 py-2"><i>{{phrase}}</i></div>
                          </td>
                      </tr>
                  </tbody>
              </table>
          </div>
          </template>
      </div>
      </template>
  </div>
  `
}


