import UnificationSwitchableList from "./UnificationSwitchableList.js";
import UnificationRightPane from "./UnificationRightPane.js";

export default {
  data () {
    return {
      entryId: null,
      lexicalUnitId: null,
      unifiedFrameId: null,
      isEdit: false,
      gettext: window.gettext,
    };
  },
  components: {UnificationSwitchableList, UnificationRightPane},
  methods: {
    lexicalUnitSelected (entryId, lexicalUnitId) {
      this.entryId = entryId;
      this.lexicalUnitId = lexicalUnitId;
      this.isEdit = false;
    },
    unifiedFrameSelected (unifiedFrameId) {
      this.unifiedFrameId = unifiedFrameId;
      this.isEdit = true;
    }
  },
  mounted () {
    Split(['#right-pane', '#examples'], {
      direction: 'vertical',
      sizes: [75, 25],
      gutterSize: 4,
    });
  },
  template: `
    <div id="entries-list" class="col h-100 w-100 px-0">
        <div id="entries-list-div" class="col p-0 h-100 w-100 overflow-auto">
            <unification-switchable-list
              @lexical-unit-selected="lexicalUnitSelected"
              @unified-frame-selected="unifiedFrameSelected"
            />
        </div>
    </div>
    <div id="entry-display" class="col h-100 p-0">
      <div id="right-pane">
        <unification-right-pane 
          :entryId="entryId" 
          :lexicalUnitId="lexicalUnitId" 
          :initialUnifiedFrameId="unifiedFrameId"
          :initialIsEdit="isEdit" />
      </div>
        <div class="col w-100 p-0 tab-pane" id="examples">
          <table id="unmatched-examples" class="table table-sm table-hover">
          <thead>
              <tr>
                  <th scope="col">{{ gettext("Przykład") }}</th>
                  <th scope="col">{{ gettext("Źródło") }}</th>
                  <th scope="col">{{ gettext("Opinia") }}</th>
              </tr>
          </thead>
          <tbody id="unmatched-examples-list">
          </tbody>
          </table>
        <p class="mx-1 my-1" id="unmatched-no-examples">{{ gettext("Brak przykładów") }}</p>
      </div>
    </div>
  `
};
