from django.urls import path

from . import views

app_name = 'unifier'

urlpatterns = [
    path('save_synset_preference/', views.save_synset_preference, name='save_synset_preference'),
    path('save_predefined_preference/', views.save_predefined_preference, name='save_predefined_preference'),
    path('save_relational_selectional_preference/', views.save_relational_selectional_preference, name='save_relational_selectional_preference'),
    path('get_unified_frames/', views.get_unified_frames, name='get_unified_frames'),
    path('get_unified_frame/', views.get_unified_frame, name='get_unified_frame'),
    path('extract_frames_to_new_frame/', views.extract_frames_to_new_frame, name='extract_frames_to_new_frame'),
    path('change_slowal2unified_fram_argument_mapping/', views.change_slowal2unified_fram_argument_mapping, name='change_slowal2unified_fram_argument_mapping'),
    path('change_slowal_frame_status/', views.change_slowal_frame_status, name='change_slowal_frame_status'),
    path('save_unified_frame_title/', views.save_unified_frame_title, name='save_unified_frame_title'),
    path('save_selected_role/', views.save_selected_role, name='save_selected_role'),
    path('save_new_role/', views.save_new_role, name='save_new_role'),
    path('add_argument/', views.add_argument, name='add_argument'),
    path('remove_argument/', views.remove_argument, name='remove_argument'),
    path('duplicate_unified_frame/', views.duplicate_unified_frame, name='duplicate_unified_frame'),
    path('change_unified_frame_status_to_ready/', views.change_unified_frame_status_to_ready, name='change_unified_frame_status_to_ready'),
    path('remove_selectional_preference/', views.remove_selectional_preference, name='remove_selectional_preference'),
    path('build_unified_frame_xml/', views.build_unified_frame_xml, name='build_unified_frame_xml'),
    path('frame_assign/', views.frame_assign, name='frame_assign'),
    path('delete_unified_frame/<int:unified_frame_id>/', views.delete_unified_frame, name='delete_unified_frame'),
    path('change_unified_frame_status_to_verified_by_superleksykograf/', views.change_unified_frame_status_to_verified_by_superleksykograf, name='change_unified_frame_status_to_verified_by_superleksykograf'),

    path('hierarchy_assign/', views.hierarchy_assign, name='hierarchy_assign'),
    path('hierarchy_unassign/', views.hierarchy_unassign, name='hierarchy_unassign'),
    path('get_hierarchy_hyponyms/<int:unified_frame_id>/', views.get_hierarchy_hyponyms, name='get_hierarchy_hyponyms'),
    path('get_hierarchy_hyperonyms/<int:unified_frame_id>/', views.get_hierarchy_hyperonyms, name='get_hierarchy_hyperonyms'),

    path('check_unified_frame_title_uniq/', views.check_unified_frame_title_uniq, name='check_unified_frame_title_uniq'),
]
