from django.contrib.auth import views as auth_views
from django.urls import include, path, re_path, reverse_lazy
from django.views.generic import TemplateView

from shellvalier.environment import get_environment
from . import views
from . import forms

app_name = 'users'

urlpatterns = [
    path('', views.user_list, name='user_list'),
    path('add/', views.user_add, name='user_add'),
    path('<int:pk>/edit/', views.user_edit, name='user_edit'),
    path('profile/', views.user_profile, name='user_profile'),
    path(
        'login/',
        auth_views.LoginView.as_view(
            template_name='login.html',
            success_url=reverse_lazy('dash'),
            extra_context={'helper': forms.login_form_helper},
        ),
        name='login',
    ),
    path('logout/', auth_views.LogoutView.as_view(), name='logout'),
    path(
        'psasword-change/',
        auth_views.PasswordChangeView.as_view(
            template_name='password_change.html',
            success_url=reverse_lazy('users:user_profile'),
            extra_context={'helper': forms.password_change_form_helper},
        ),
        name='password_change'),
    path(
        'password-reset/',
        auth_views.PasswordResetView.as_view(
            template_name='password_reset.html',
            from_email=get_environment('EMAIL_FROM', default=None),
            email_template_name='password_reset_email.html',
            success_url=reverse_lazy('users:password_reset_requested'),
            extra_context={'helper': forms.password_reset_form_helper},
        ),
        name='password_reset',
    ),
    path(
        'password-reset/check-your-inbox/',
        TemplateView.as_view(template_name='password_reset_requested.html'),
        name='password_reset_requested',
    ),
    path(
        'password-reset/<uidb64>/<token>/',
        auth_views.PasswordResetConfirmView.as_view(
            template_name='password_reset_form.html',
            success_url=reverse_lazy('users:login'),
            extra_context={'helper': forms.password_reset_set_password_form_helper},
        ),
        name='password_reset_confirm'
    ),
    re_path(r'^notes/(?P<model>\w+.\w+)/(?P<pk>\w+)/(?P<type>\w+)/$', views.get_notes, name='get_notes'),
    re_path(r'^notes/(?P<model>\w+.\w+)/(?P<pk>\w+)/(?P<type>\w+)/add/$', views.add_note, name='add_note'),
    path('notes/<int:pk>/delete/', views.delete_note, name='delete_note'),
]
