from django.http import JsonResponse
from django.shortcuts import render

from common.decorators import ajax_required
from common.models import ImportInProgress

def dash(request):
    return render(request, 'dash.html')

def error_400(request, exception):
    return render(request, 'base.html', status=400)

def error_404(request, exception):
    return render(request, 'base.html', status=404)

@ajax_required
def get_import_status(request):
    if request.method == 'GET':
        in_progress = bool(ImportInProgress.objects.all().count())
        return JsonResponse({'status' : 'in_progress' if in_progress else 'complete'})
