function setup_entries_list(options) {
    const can_see_assignees = has_permission("users.view_assignment");

    function is_assigned_to_user_renderer (_1, _2, data) {
        return (
            data
            && data.lexical_units
            && data.lexical_units.some(lu => lu.assignee_username === window.USER_USERNAME && lu.status == 'O')
        ) ? gettext("tak") : gettext("nie");
    }

    var datatable = setup_datatable({
        element: options.table,
        selectFirst: true,
        url: '/' + window.lang + '/entries/get_entries/?with_lexical_units=true',
        columns: [
            { data: 'lemma' },
            { data: 'POS' },
            { render: (_1, _2, data) => (data && data.lexical_units && data.lexical_units.some(lu => lu.assignee_username !== null)) ? gettext("nie") : gettext("tak") },
            can_see_assignees ? { data: 'assignee_username' } : { render: is_assigned_to_user_renderer },
        ],
        selectEntryId: options.selectEntryId,
    });
    datatable.on('click', 'tr.entry', function () {
        var row = datatable.row(this);
        var has_drilldown = row.child.isShown();
        $('.drilldown:visible', options.table).each(function () { datatable.row($(this).data("row")).child.hide(); });
        if (!has_drilldown) {
            if (!row.data()) return;
            var drilldown = $("<div>").addClass("drilldown").data("row", this);
            row.child(drilldown).show();
            setup_lexical_units_table(drilldown, row.data().lexical_units, can_see_assignees, options);
            drilldown.closest("td").addClass("p-0 pl-4");
        }
    });
    return datatable;
}

function setup_lexical_units_table(drilldown, lexical_units, can_see_assignees, options) {
    if (!lexical_units.length) {
        return '';
    }

    function get_lexical_unit_row(lexical_unit) {
        const is_assigned_to_user = lexical_unit.assignee_username === window.USER_USERNAME;
        return $(`
            <tr class="lexical-unit">
                <td class="p-1">${lexical_unit.display}</td>
                <td class="p-1">${lexical_unit.status}</td>
                ` + (
                    can_see_assignees
                        ? `<td class="p-1">${lexical_unit.assignee_username || ""}</td>`
                        : `<td class="p-1">${is_assigned_to_user ? gettext("tak") : gettext("nie")}</td>`
                ) + `
            </tr>
        `).click(function () {
            $(this).addClass('table-primary').siblings().removeClass("table-primary");
            options.lexicalUnitSelected($(drilldown.data("row")).data("entry"), lexical_unit.pk);
        });
    }
    const table = $(`
        <table class="table table-hover">
            <thead>
                <tr>
                    <th class="p-1">${gettext("Jednostka Leksykalna")}</th>
                    <th class="p-1">${gettext("Status")}</th>
                    ` + (
                        can_see_assignees
                            ? `<th class="p-1">${gettext("Leksykograf")}</th>`
                            : `<th class="p-1">${gettext("Moje")}</th>`
                    ) + `
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    `);
    drilldown.append(table);
    lexical_units.map(function (lexical_unit) {
        const row = get_lexical_unit_row(lexical_unit);
        $("tbody", table).append(row);
        if(lexical_unit.pk === options.secondarySelectEntryId) {
            row.addClass('table-primary');
        }
    });
}

function show_notes_form($container, pk, model, refreshFunction, title, body) {
    $('.note-form', $container).html($('#note-form-template > div', $container).clone());
    $('.hide-note-form', $container).click(function () {
        $('.note-form', $container).html('');
    });
    $('.add-note', $container).click(function () {
        $.ajax({
            type: 'post',
            url: $('#note-form-template').data('url').replace('MODEL', model).replace('PK', pk),
            dataType: 'json',
            data: {
                title: $('.note-form input[name=title]').val(),
                note: $('.note-form textarea[name=note]').val()
            },
            timeout: 5000,
            success: function (response) {
                refreshFunction();
            },
            error: function () {
                alert(gettext('Nie udało się dodać notatki.'));
            }
        });
    });
    if(title) {
        const input = $('#title', $container);
        input[1].defaultValue = title;
    }
    if(body) {
        const input = $('#note', $container);
        input[1].defaultValue = body;
    }
}

function setup_notes($container, $template, pk, model, refreshFunction, title, body) {
    $container.html($template.children().clone());
    $('.show-note-form', $container).click(function () {
        show_notes_form($container, pk, model, refreshFunction, title, body);
        return false
    });
    if(title || body) {
        show_notes_form($container, pk, model, refreshFunction, title, body);
    }
    $.ajax({
        type: 'get',
        url: $('.notes-table').data('url').replace('MODEL', model).replace('PK', pk),
        success: function (data) {
            data.notes.map(function (note) {
                $('.notes-table tbody', $container).append(
                    `
                        <tr role="button" data-toggle="collapse" data-target="#note-${note.pk}" class="cursor-pointer">
                            <td>${note.title}</td>
                            <td>${note.owner_label}</td>
                            <td>
                                <a
                                    href="#"
                                    class="btn btn-xs btn-outline-dark float-right delete-note"
                                    data-pk="${note.pk}"
                                >&times;</a>
                            </td>
                        </tr>
                        <tr id="note-${note.pk}" class="collapse v-hidden"><td colspan="3">${note.note}</td></tr>
                    `
                );
                $('.delete-note', $container).click(function (e) {
                    e.preventDefault();
                    const pk = $(this).data("pk");
                    if (!confirm(gettext("Czy na pewno chcesz usunąć notatkę?"))) return false;
                    $.ajax({
                        type     : 'delete',
                        url      : `/${lang}/users/notes/${pk}/delete/`,
                        timeout  : 5000,
                        success  : function () {
                            refreshFunction();
                        },
                        error    : function () {
                            alert(gettext('Nie udało się usunąć notatki.'));
                        }
                    });
                    return false;
                });
            });
        }
    })
}
