import LexicalUnitDisplay from './LexicalUnitDisplay.js';
import LexicalUnitEdit from './LexicalUnitEdit.js';

export default {
  components: {LexicalUnitDisplay, LexicalUnitEdit},
  props: {
    entryId: Number,
    lexicalUnitId: Number,
    initialUnifiedFrameId: Number,
    initialIsEdit: false,
  },
  emits: ['refreshEntriesList'],
  data () {
    return this.getInitialData();
  },
  methods: {
    getInitialData () {
      return {
        isEdit: this.initialIsEdit,
        key: this.lexicalUnitId,
        entryIdLocal: this.entryId,
        unifiedFrameId: this.initialUnifiedFrameId,
        previewedUnifiedFrameId: null
      };
    },
    goToDisplay () {
      this.isEdit = false;
      this.unifiedFrameId = null;
    },
    refresh () {
      this.key = null;
      setTimeout(() => { this.key = this.lexicalUnitId; }, 0);
    },
    swapFrames (previewedUnifiedFrameId) {
      this.previewedUnifiedFrameId = this.unifiedFrameId;
      this.unifiedFrameId = previewedUnifiedFrameId;
      this.refresh();
    },
    refreshEntriesList() {
      this.$emit('refreshEntriesList');
    }
  },
  watch: {
    initialIsEdit () {
      Object.assign(this, this.getInitialData());
    },
    lexicalUnitId () {
      Object.assign(this, this.getInitialData());
    },
    initialUnifiedFrameId () {
      Object.assign(this, this.getInitialData());
    }
  },
  template: `
    <div v-if="key || unifiedFrameId" :key="(key, entryIdLocal, unifiedFrameId, isEdit)" class="row h-100 m-0 p-0 overflow-auto" id="semantics-top-pane">
      <lexical-unit-display
        v-if="key && !isEdit"
        :key="key"
        :entryId="entryIdLocal"
        :lexicalUnitId="key"
        @refresh="refresh"
        @refresh-entries-list="refreshEntriesList"
      />
      <lexical-unit-edit
        ref="lexicalUnitEdit"
        v-if="unifiedFrameId && isEdit"
        :key="unifiedFrameId"
        :readOnly="false"
        :unifiedFrameId="unifiedFrameId"
        :previewedUnifiedFrameId="previewedUnifiedFrameId"
        :initialRightPaneTab="unifiedFrameId !== previewedUnifiedFrameId ? 'frame_preview' : null"
        @go-to-display="goToDisplay"
        @swap-frames="swapFrames"
        @refresh-entries-list="refreshEntriesList"
      />
    </div>
  `
}
