export default {
  props: { text: String },
  data () {
    return {
      iconUrl: window.STATIC_URL + 'common/img/info.svg'
    }
  },
  computed: {
    quotedText () {
      return this.text.replace(/"/g, '&quot;');
    }
  },
  mounted () {
    $(this.$refs.tooltip).tooltip();
  },
  template: `
    <span
      data-toggle="tooltip"
      data-placement="bottom"
      data-html="true"
      :title="quotedText"
      ref="tooltip"
    >
      <img :src="iconUrl" alt="info" width="14" height="14" />
    </span>
  `
}
