#-*- coding:utf-8 -*-

import datetime
import os

from django.core.management.base import BaseCommand
from optparse import make_option

from unifier.models import UnifiedFrame
from django.contrib.auth.models import User
from users.models import Assignment

from common.management.commands.valunifier_tei import createteixml

BASEPATH = 'data/tei/'

class Command(BaseCommand):
    args = ''
    help = 'Export ValUnifier in TEI format'

    def add_arguments(self, parser):
        parser.add_argument('-i', '--individual', action='store_true', help='Gen individual files.')
    
    def handle(self, **options):

        now = datetime.datetime.now().strftime('%Y%m%d')

        if not options['individual']:
            print("Full dictionary")
            outfile = 'valunifier_' + now + '.xml'
            outpath = os.path.join(BASEPATH, outfile)
            frames = UnifiedFrame.objects.all()
            createteixml(outpath, frames)

        else:
            for user in User.objects.all():
                print("Part for " + user.username)
                frames = []
                for assignment in Assignment.objects.filter(user=user):
                    if assignment.subject_ct.model_class() == UnifiedFrame:               
                        frames.append(assignment.subject_ct.get_object_for_this_type(id=assignment.subject_id))
                outfile = user.username + '_' + now + '.xml'
                outpath = os.path.join(BASEPATH, outfile)
                if len(frames) > 0:
                    createteixml(outpath, frames)
            

