import {slowal_frames2selecional_preferencies} from "../shared/utils.js";

export default class SelectionalPreference {

  predefined = [];
  relations = [];
  synsets = [];
  change = false;

  constructor() {
    this.loadPredefinedSelections();
    this.loadRelations();
  }

  loadPredefinedSelections() {
    $.ajax({
      dataType: "json",
      url: `/${lang}/entries/predefined_preferences/`,
      success: (data) => {
        this.predefined = data.predefined;
      },
      async: false
    });
  }

  loadRelations() {
    $.ajax({
      dataType: "json",
      url: `/${lang}/entries/relations/`,
      success: (data) => {
        this.relations = data.relations;
      },
      async: false
    });
  }

  getSynsets(context, pos) {

    if ((typeof pos) == 'undefined') {
      pos = '_';
    }

    $.ajax({
      dataType: "json",
      url: `/${lang}/entries/synsets/`,
      data: {base: context, pos: pos},
      success: function (data) {
        this.synsets = data.synsets
      }.bind(this),
      async: false
    });

    let display = "";

    let i;
    for (i = 0; i < this.synsets.length; i++) {
      display += "<input type = \"radio\" name = \"synset\" value = \"" + this.synsets[i].id + "\"><div>";
      let j;
      for (j = 0; j < this.synsets[i].content.length; j++) {
        const lexical_unit = this.synsets[i].content[j];
        display += lexical_unit.base + "-" + lexical_unit.sense + ": <i>" + lexical_unit.glossa + "</i><br>";
      }
      display += "</div>";
    }

    return display;
  }

  predefinedSelect() {
    let display = "";

    let i;
    for (i = 0; i < this.predefined.length; i++) {
      display += "<input type = \"checkbox\" name = \"predef\" value = \"" + this.predefined[i].id + "\">" + this.predefined[i].content + "<br>";
    }

    return display;
  }

  relationsSelect() {
    let display = "<select name = \"rel\">";

    let i;
    for (i = 0; i < this.relations.length; i++) {
      display += "<option value = \"" + this.relations[i].id + "\">" + this.relations[i].content + "</option>";
    }
    display += "</select>"
    return display;
  }

  argumentSelect(frame, complement_id) {
    let display = "<select name = \"arg\">";

    let i;
    for (i = 0; i < frame.arguments.length; i++) {
      var local_complement_id = frame.arguments[i].id;
      if (local_complement_id && local_complement_id !== complement_id && frame.arguments[i].role) {
        display += "<option value = \"" + local_complement_id + "\">" + frame.arguments[i].role.str + "</option>";
      }
    }

    display += "</select>"

    return display;
  }

  relationArgument(frame, complement_id) {
    return this.relationsSelect() + "<br><br>" + this.argumentSelect(frame, complement_id);
  }

  attachPlWNContextAutocomplete() {
    $('#plWN_context_selection').autocomplete({
      select: function (event, ui) {
      },
      source: function (req, add) {
        fetch(`/${lang}/entries/plWN_context_lookup/?` + new URLSearchParams(req))
          .then(function (response) {
            return response.json();
          })
          .then(function (data) {
            add(data['result']);
          });
      },
    });
  }

  addSelectivePreference(unified_frame, unified_frame_active_argument_id, frames, callbackFunction) {
    if (!unified_frame_active_argument_id) return;
    this.addSelectivePreferenceBase(unified_frame, frames, unified_frame_active_argument_id, callbackFunction);
  }

  addSelectivePreferenceBase(unified_frame, frames, complement_id, callbackFunction) {
    let unified_frame_id = unified_frame.id;

    const submitSynsetSelection = (e, v, m, f) => {
      if (v == -1) {
        e.preventDefault();
        $.prompt.goToState('state2');
      }
      if (v == 1) {
        e.preventDefault();
        const synset = normalizeFormData(f.synset);

        let i;
        for (i = 0; i < synset.length; i++) {
          this.saveSynsetPreference(unified_frame_id, complement_id, synset[i])
        }
        $.prompt.goToState('state0');
      }
    }

    const existingSelect = function () {
      let availablePreferencies = slowal_frames2selecional_preferencies(unified_frame, frames)[complement_id];
      if (!availablePreferencies) {
        return gettext('Brak preferencji selekcyjnych do wyboru.')
      }
      return availablePreferencies.map(preference => {
        return `<label><input type="checkbox" name="existing" value="${preference.type}:${preference.id}" /> ${preference.str}</label><br />`;
      }).join("");
    };

    const select_preference = {
      state0: {
        title: 'Typ preferencji selekcyjnej',
        html: 'Wybierz typ preferencji selekcyjnej',
        buttons: {Istniejąca: 0, Predefiniowana: 1, Słowosieć: 2, Relacja: 3, Koniec: -1},
        focus: -1,
        submit: (e, v, m, f) => {
          if (v == -1) {
            e.preventDefault();
            $.prompt.close();

            callbackFunction();
          }
          if (v === 0) {
            e.preventDefault();
            $.prompt.goToState('state4');
          }
          if (v == 1) {
            e.preventDefault();
            $.prompt.goToState('state1');
          }
          if (v == 2) {
            e.preventDefault();
            $.prompt.goToState('state2');
          }
          if (v == 3) {
            e.preventDefault();
            $.prompt.goToState('state3');
          }
        }
      },
      state1: {
        title: 'Wybierz preferencję selekcyjną',
        html: this.predefinedSelect(),
        buttons: {Anuluj: -1, Zatwierdź: 1},
        focus: 1,
        submit: (e, v, m, f) => {

          if (v == -1) {
            e.preventDefault();
            $.prompt.goToState('state0');
          }
          if (v == 1) {
            e.preventDefault();
            const predef = normalizeFormData(f.predef);

            let i;
            for (i = 0; i < predef.length; i++) {
              this.savePredefinedPreference(unified_frame_id, complement_id, predef[i])
            }
            $.prompt.goToState('state0');
          }
        }
      },
      state2: {
        title: 'Wybierz preferencję selekcyjną',
        html: "<input id=\"plWN_context_selection\" type=\"text\" name=\"context\">",
        buttons: {Anuluj: -1, Wyszukaj: 1},
        focus: 1,
        submit: (e, v, m, f) => {
          if (v == -1) {
            e.preventDefault();
            $.prompt.goToState('state0');
          }
          if (v == 1) {
            e.preventDefault();
            $.prompt.removeState('state21');
            $.prompt.addState('state21', {
              title: 'Znaczenia',
              html: this.getSynsets(f.context),
              buttons: {Anuluj: -1, Zatwierdź: 1},
              focus: 1,
              submit: submitSynsetSelection
            }, 'state2');
            $.prompt.goToState('state21');
          }
        }
      },
      state3: {
        title: 'Wybierz relację i argument',
        html: this.relationArgument(unified_frame, complement_id),
        buttons: {Anuluj: -1, Zatwierdź: 1},
        focus: 1,
        submit: (e, v, m, f) => {
          if (v == -1) {
            e.preventDefault();
            $.prompt.goToState('state0');
          }
          if (v == 1) {
            e.preventDefault();

            const rel = normalizeFormData(f.rel);
            const args = normalizeFormData(f.arg);

            let i, j;
            for (i = 0; i < rel.length; i++) {
              for (j = 0; j < args.length; j++) {
                this.saveRelationalSelectionalPreference(unified_frame_id, complement_id, args[j], rel[i])
              }
            }

            $.prompt.goToState('state0');
          }
        }
      },
      state4: {
        title: 'Wybierz z istniejących',
        html: existingSelect(),
        buttons: {Anuluj: -1, Zatwierdź: 1},
        focus: 1,
        submit: (e, v, m, f) => {
          if (v == -1) {
            e.preventDefault();
            $.prompt.goToState('state0');
          }
          if (v == 1) {
            e.preventDefault();
            normalizeFormData(f.existing).map(choice => {
              let [type, id] = choice.split(':');
              switch (type) {
                case 'meanings.Synset':
                  this.saveSynsetPreference(unified_frame_id, complement_id, id);
                  break;
                case 'semantics.PredefinedSelectionalPreference':
                  this.savePredefinedPreference(unified_frame_id, complement_id, id);
                  break;
                case 'semantics.RelationalSelectionalPreference':
                  this.saveRelationalSelectionalPreference(unified_frame_id, complement_id, null, null);  // TODO
                  break;
              }
            });
            $.prompt.goToState('state0');
          }
        }
      },
    };
    if (this.change == true) {
      this.alertSemantics();
    } else {
      $.prompt(select_preference);
      this.attachPlWNContextAutocomplete();
    }

  }

  saveSynsetPreference(frame_id, complement_id, synset_preference_id) {
    const data = {
      'frame_id': frame_id,
      'complement_id': complement_id,
      'synset_preference_id': synset_preference_id
    };
    $.ajax({
      type: 'post',
      url: '/' + lang + '/unifier/save_synset_preference/',
      dataType: 'json',
      data: data,
      timeout: 60000,
      success: function (response) {
        show_info('Preferencja zosała zapisana');
      },
      error: function (request, errorType, errorMessage) {
        show_error(errorType + ' (' + errorMessage + ')');
      }
    });
  }

  savePredefinedPreference(frame_id, complement_id, predefined_preference_id) {
    const data = {
      'frame_id': frame_id,
      'complement_id': complement_id,
      'predefined_preference_id': predefined_preference_id
    };
    $.ajax({
      type: 'post',
      url: '/' + lang + '/unifier/save_predefined_preference/',
      dataType: 'json',
      data: data,
      timeout: 60000,
      success: function (response) {
        show_info('Preferencja zosała zapisana');
      },
      error: function (request, errorType, errorMessage) {
        show_error(errorType + ' (' + errorMessage + ')');
      }
    });
  }

  saveRelationalSelectionalPreference(frame_id, complement_id_from, complement_id_to, relation_id) {
    const data = {
      'frame_id': frame_id,
      'complement_id_from': complement_id_from,
      'complement_id_to': complement_id_to,
      'relation_id': relation_id
    };
    $.ajax({
      type: 'post',
      url: '/' + lang + '/unifier/save_relational_selectional_preference/',
      dataType: 'json',
      data: data,
      timeout: 60000,
      success: function (response) {
        show_info('Preferencja zosała zapisana');
      },
      error: function (request, errorType, errorMessage) {
        show_error(errorType + ' (' + errorMessage + ')');
      }
    });
  }

}
