import os

from django.apps import AppConfig


class SynsetHierarchy:
    id = -1
    hyponyms = []
    hyperonyms = []

    def __init__(self, id):
        self.id = id
        self.hyponyms = []
        self.hyperonyms = []


synset_hierarchy_dict = {}


class UnifierConfig(AppConfig):
    name = 'unifier'

    def ready(self):

        LOADING_THE_SLOWOSIEC_ONTOLOGY_HIERARCHY_DISABLED = os.getenv('LOADING_THE_SLOWOSIEC_ONTOLOGY_HIERARCHY_DISABLED')

        if LOADING_THE_SLOWOSIEC_ONTOLOGY_HIERARCHY_DISABLED != 'true':
            print("Loading the slowosiec ontology hierarchy...")
            from meanings.models import Synset
            from django.db.models import Prefetch
            i = 0
            objs = Synset.objects
            objs = objs.prefetch_related(
                Prefetch(
                    "hypernyms",

                )
            )
            for synset in objs.all():
                if i % 10000 == 0:
                    print("i: "+str(i))
                i = i + 1
                curr = None
                if synset.id not in synset_hierarchy_dict:
                    curr = SynsetHierarchy(id=synset.id)
                    synset_hierarchy_dict[synset.id] = curr
                else:
                    curr = synset_hierarchy_dict[synset.id]

                for hypernym in synset.hypernyms.all():
                    curr_hypernym = None
                    if hypernym.id not in synset_hierarchy_dict:
                        curr_hypernym = SynsetHierarchy(id=hypernym.id)
                        synset_hierarchy_dict[hypernym.id] = curr_hypernym
                    else:
                        curr_hypernym = synset_hierarchy_dict[hypernym.id]

                    curr.hyperonyms.append(curr_hypernym)
                    curr_hypernym.hyponyms.append(curr)

            print("Slowosiec ontology hierarchy loaded.")

