function setup_entries_for_frames_list(options) {
    const can_see_assignees = has_permission("users.view_assignment");

    function is_assigned_to_user_renderer (_1, _2, data) {
        return (
            data
            && data.lexical_units
            && data.lexical_units.some(lu => lu.assignee_username === window.USER_USERNAME && lu.status == 'O')
        ) ? gettext("tak") : gettext("nie");
    }

    const ajaxURL = can_see_assignees ? '/' + window.lang + '/entries/get_entries/?with_lexical_units=true&has_unified_frame=true' : '/' + window.lang + '/entries/get_entries/?with_lexical_units=true&has_unified_frame=true&exclude_status=N&restrict_to_user='+window.USER_USERNAME;

    const datatable = setup_datatable({
        element: options.table,
        selectFirst: true,
        url: ajaxURL,
        columns: [
            { data: 'lemma' },
            { data: 'POS' },
            { render: (_1, _2, data) => (data && data.lexical_units && data.lexical_units.some(lu => lu.assignee_username !== null)) ? gettext("nie") : gettext("tak") },
            can_see_assignees ? { data: 'assignee_username' } : { render: is_assigned_to_user_renderer },
        ],
        hidden_columns: can_see_assignees ? [2] : [2,3],
        selectEntryId: options.selectEntryId,
    });
    datatable.on('click', 'tr.entry', function () {
        const row = datatable.row(this);
        const has_drilldown = row.child.isShown();
        $('.drilldown:visible', options.table).each(function () { datatable.row($(this).data("row")).child.hide(); });
        if (!has_drilldown) {
            if (!row.data()) return;
            const drilldown = $("<div>").addClass("drilldown").data("row", this);
            row.child(drilldown).show();
            setup_lexical_units_for_frames_table(drilldown, row.data().lexical_units, can_see_assignees, options);
            drilldown.closest("td").addClass("p-0 pl-4");
        }
    });
}

function setup_lexical_units_for_frames_table(drilldown, lexical_units, can_see_assignees, options) {
    if (!lexical_units.length) {
        return '';
    }

    function get_lexical_unit_row(lexical_unit) {
        const is_assigned_to_user = lexical_unit.assignee_username === window.USER_USERNAME;
        return $(`
            <tr class="lexical-unit">
                <td class="p-1">${lexical_unit.display}</td>
                <td class="p-1">${"<img src='/static/entries/img_status/"+lexical_unit.status+"_status.svg' width='10' height='10'> "+lexical_unit.status}</td>
                ` + (
                    can_see_assignees
                        ? `<td class="p-1">${lexical_unit.assignee_username || ""}</td>`
                        : ``
                ) + `
            </tr>
        `).click(function () {
            $(this).addClass('table-primary').siblings().removeClass("table-primary");
            options.lexicalUnitSelected(lexical_unit.unified_frame_id, $(drilldown.data("row")).data("entry"), lexical_unit.pk);
        });
    }
    const table = $(`
        <table class="table table-hover">
            <thead>
                <tr>
                    <th class="p-1">${gettext("Jednostka Leksykalna")}</th>
                    <th class="p-1">${gettext("Status")}</th>
                    ` + (
                        can_see_assignees
                            ? `<th class="p-1">${gettext("Leksykograf")}</th>`
                            : ``
                    ) + `
                </tr>
            </thead>
            <tbody></tbody>
        </table>
    `);
    drilldown.append(table);
    lexical_units.map(function (lexical_unit) {
        const row = get_lexical_unit_row(lexical_unit);
        $("tbody", table).append(row);
        if(lexical_unit.pk === options.secondarySelectEntryId) {
            row.addClass('table-primary');
        }
    });
}
