function clear_form_errors(form) {
    form.find('.form-error').remove();
    form.find('.alert-danger').remove();
}

function show_form_errors(form, errors) {
    show_error_alert(gettext('Formularz filtrowania zawiera błędy.'), form.find('input[type="submit"]').prev());
    for (var field in errors) {
        var field_element = $('#id_' + field);
        field_element.after('<p class="bg-warning form-error">' + errors[field] + '</p>');
    }
}

function bind_add_subforms(selector) {
    selector.find('.add-button').click(function() {
        add_subform($(this));
    });
    // *don’t* do that – this makes adding ‘or’ impossible
    // TODO: do that only when e.g. ctrl key is pressed?
    /*.closest('.input-group').find('select').change(function() {
        // also add subform on selecting subform type
        $(this).siblings().find('.add-button').click();
    });*/
}

function bind_remove_subforms(selector) {
    selector.find('.remove-button').mouseenter(function() {
        $(this).closest('.subform').addClass('to-remove').find('.subform').addClass('to-remove');
    }).mouseleave(function() {
        $(this).closest('.subform').removeClass('to-remove').find('.subform').removeClass('to-remove');
    }).click(function() {
        var to_remove = $(this).closest('form');
        var next = to_remove.next();
        var prev = to_remove.prev();
        to_remove.remove();
        // remove any ‹or›s and ‹others›s that are no longer surrounded by forms
        if ((prev.hasClass('form-or') || prev.hasClass('form-other')) && !prev.next().hasClass('subform')) {
            prev.remove();
        }
        if ((next.hasClass('form-or') || next.hasClass('form-other')) && !next.prev().hasClass('subform')) {
            next.remove();
        }
    });
}

function collapsed_attr_vals(element, negated) {
    var tag = element.tagName();
    var vals = [];
    var neg_prefix = (negated ? (gettext('nie') + ' ') : '');
    if (tag === 'input') {
        if (element.prop('type') === 'checkbox') {
            if (element.prop('checked')) {
                vals.push(neg_prefix + '<i>' + element.siblings('label').immediateText().trim() + '</i>');
            }
        } else if (element.prop('type') === 'text') {
            var val = element.val();
            if (val && val !== ".*") {
                vals.push(neg_prefix + '<i>"' + val + '"</i>');
            }
        } else {
            vals.push('??? ' + element.attr('class') + ' ???');
        }
    } else if (tag === 'select') {
        return element.val().map(x => neg_prefix + '<i>' + element.find('option[value="' + x + '"]').html() + '</i>');
    } else {
        element.children().each(function() {
            vals = vals.concat(collapsed_attr_vals($(this), negated));
        });
    }
    return vals;
}

function collapsed_subform_desc(element) {
    var tag = element.tagName();
    var ret = '';
    if (tag === 'label') {
        var input_siblings = element.siblings('input');
        if (input_siblings.length === 0) {
            var neg = element.hasClass('negated2');
            var vals = [];
            element.next().children().each(function() {
                vals = vals.concat(collapsed_attr_vals($(this), neg));
            });
            if (vals.length > 0) {
                ret += '<b>' + element.html().trim() + ': </b>';
                ret += vals.join(' ' + (neg ? gettext('i') : gettext('lub')) + ' ');
            }
            return ret;
        } else {
            return '';
        }
    } else if (tag === 'form') {
        var attributes = [];
        element.children('fieldset').children('.form-group.row').children('label').each(function() {
            var attr = collapsed_subform_desc($(this));
            if (attr) {
                attributes.push(attr);
            }
        });
        if (attributes.length > 0) {
            ret += attributes.join(', ');
        }
        element.children('fieldset').children('.and-or-forms').each(function() {
            var elems = [];
            $(this).children().each(function() {
                var child = $(this);
                var child_tag = child.tagName();
                var elem = '';
                if (child_tag === 'form') {
                    if (child.hasClass('negated')) {
                        elem += gettext('nie') + ' ';
                    }
                    elem += '[' + child.children('fieldset').children('legend').immediateText().trim() + '] ' + collapsed_subform_desc(child);
                } else if (child.hasClass('form-or') || child.hasClass('form-other')) {
                    elem = child.find('span').html();
                }
                if (elem) {
                    elems.push('<li>' + elem + '</li>');
                }
            });
            if (elems.length > 0) {
                ret += '<ul>' + elems.join('') + '</ul>';
            }
        });
        return ret;
    } else if (element.siblings('label').length > 0) {
        return '';
    } else {
        element.children().each(function() {
            ret += collapsed_subform_desc($(this));
        });
        return ret;
    }
}

function bind_collapse_subforms(selector) {
    selector.find('.collapse-button').mouseenter(function() {
        $(this).closest('.subform').addClass('to-collapse').find('.subform').addClass('to-collapse');
    }).mouseleave(function() {
        $(this).closest('.subform').removeClass('to-collapse').find('.subform').removeClass('to-collapse');
    }).click(function() {
        if ($(this).data('collapsed')) {
            $(this).closest('legend').nextAll().show();
            $(this).closest('legend').find('.collapsed-info').html('');
            $(this).html(gettext('zwiń'));
            $(this).data('collapsed', false);
        } else {
            $(this).closest('legend').nextAll().hide();
            $(this).closest('legend').find('.collapsed-info').html(collapsed_subform_desc($(this).closest('.subform')));
            $(this).html(gettext('rozwiń'));
            $(this).data('collapsed', true);
        }   
    });
}

function bind_negations(selector) {
    // subform negations
    selector.find('.negate-switch').find('.checkboxinput').change(function(event) {
        var checked = $(this).prop('checked');
        var subform = $(this).closest('.subform');
        if (checked) {
            if (subform.siblings('.form-other').length > 0) {
                show_warning_alert(gettext('Łączenie negacji elementu z operatorem ‹inny› na jednym poziomie formularza jest niemożliwe.'), $(this).closest('.form-group.row'));
                $(this).prop('checked', false);
            } else {
                subform.addClass('negated');
            }
        } else {
            subform.removeClass('negated');
        }
    });
    // attribute negations
    selector.find('label.col-sm-2').mouseenter(function() {
        var label = $(this);
        // selects for subform adding are not negatable
        if (label.parent().parent().hasClass('and-or-forms')) {
            return;
        }
        if (label.hasClass('negated2')) {
            show_info(gettext('Kliknij, aby wyłączyć negację tego atrybutu.'));
        } else {
            show_info(gettext('Kliknij, aby zanegować ten atrybut.'));
        }
    }).mouseleave(function() {
        clear_info();
    }).click(function() {
        var label = $(this);
        // selects for subform adding are not negatable
        if (label.parent().parent().hasClass('and-or-forms')) {
            return;
        }
        if (label.hasClass('negated2')) {
            label.removeClass('negated2');
        } else {
            label.addClass('negated2');
        }
    });
}

function bind_subform_conjunctions(selector, or) {
    var conj_type = or ? 'or' : 'other';
    var conj_type2 = or ? 'other' : 'or';
    selector.find('.' + conj_type + '-button').click(function() {
        var div = $(this).closest('.and-or-forms');
        if (div.children('.form-' + conj_type2).length > 0) {
            show_warning_alert(gettext('Łączenie operatorów ‹lub› i ‹inny› na jednym poziomie formularza jest niemożliwe.'), div);
            return;
        }
        // prevAll: the elements are returned in order beginning with the closest sibling
        var insert_after = $(this).prevAll('.subform').first();
        // if there is no subform yet, nothing will be inserted
        if (insert_after.length === 0) {
            show_warning_alert(gettext('Proszę najpierw dodać element,') + ' ' + (or ? gettext('aby użyć operatora ‹lub›') : gettext('aby użyć operatora ‹inny›')) + '.', div);
            return;
        }
        if (!or && div.children('.subform.negated').length > 0) {
            show_warning_alert(gettext('Łączenie operatora ‹inny› z negacją elementu na jednym poziomie formularza jest niemożliwe.'), div);
            return;
        }
        // add the conjunction
        insert_after.after('<div class="form-' + conj_type + ' mb-1 ml-3"><span class="btn btn-primary btn-sm disabled">' + (or ? gettext('LUB') : gettext('INNY')) + '</span><button type="button" class="btn remove-' + conj_type + '-button btn-sm btn-danger">' + gettext('Usuń') + '</div>');
        insert_after.next().find('.remove-' + conj_type + '-button').mouseenter(function() {
            $(this).closest('div').addClass('to-remove');
        }).mouseleave(function() {
            $(this).closest('div').removeClass('to-remove');
        }).click(function() {
            $(this).closest('div').remove();
        });
        // add a subform
        add_subform($('#' + $(this).data('add-id')));
        if (!or) {
            show_info_alert(gettext('Wykonanie zapytania z operatorem ‹inny› może trwać zauważalnie dłużej.'), div);
        }
    });
}

function bind_autocompletes(selector) {
    selector.find('.regex-autocomplete').each(function() {
        var autocompleted = $(this);
        // https://api.jqueryui.com/autocomplete/#option-source
        autocompleted.autocomplete({
            // doesn’t work with autocompleted, perhaps bc it’s an <input> and parent is a <div>
            appendTo: autocompleted.parent(),
            source: function(request, autocompleter) {
                $.ajax({
                    type     : 'get',
                    url      : '/' + lang + '/entries/autocomplete/',
                    dataType : 'json',
                    data     : {'what' : autocompleted.data('autocomplete'), 'text' : request.term},
                    success  : function(response) {
                        autocompleter(response.suggestions);
                        $('.ui-menu-item-wrapper').each(function() {
                            var item = $(this);
                            var txt = item.html();
                            if (txt in response.tooltips) {
                                item.attr('data-toggle', 'tooltip');
                                item.attr('data-placement', 'bottom');
                                item.attr('data-html', 'true');
                                item.attr('title', response.tooltips[txt].replace(/"/g, '&quot;'));
                                item.tooltip();
                            }
                        });
                    },
                    error: function(request, errorType, errorMessage) {
                        // ‘You must always call the response even if you encounter an error.
                        // This ensures that the widget always has the correct state.’
                        autocompleter([]);
                        show_error(errorType + ' (' + errorMessage + ')');
                    }
                });
            }
        });
    });
}

function bind_clickable_labels(selector) {
    // the labels are clickable, so show it to the user by highlighting them on mouseover
    selector.find('.custom-control-label').mouseenter(function() {
        $(this).addClass('text-secondary');
    }).mouseleave(function() {
        $(this).removeClass('text-secondary');
    });
}

function bind_form_events(selector) {
    bind_add_subforms(selector);
    bind_remove_subforms(selector);
    bind_collapse_subforms(selector);
    bind_negations(selector);
    // ‘or›
    bind_subform_conjunctions(selector, true);
    // ‹other›
    bind_subform_conjunctions(selector, false);
    bind_autocompletes(selector);
    bind_clickable_labels(selector);
    activate_tooltips(selector);
}

// inserter: a callback that inserts the subform HTML into the DOM
// and returns the inserted element containing the form
function insert_subform(subform_type, inserter) {
    $.ajax({
        // TODO? this is not very nice, but we we want to wait for the form
        // to be inserted into the DOM before doing further stuff with it
        async    : false,
        type     : 'get',
        url      : '/' + lang + '/entries/get_subform/',
        data     : {'subform_type' : subform_type},
        dataType : 'json',
        success  : function(response) {
            var inserted = inserter(response.form_html);
            inserted.addClass('subform');
            bind_form_events(inserted);
        },
        error: function(request, errorType, errorMessage) {
            show_error(errorType + ' (' + errorMessage + ')');
        }
    });
}

function add_subform(button) {
    var depth = parseInt(button.closest('form').data('depth')) + 1;
    // TODO other number here?
    if (depth > 8) {
        show_warning_alert(gettext('Dodanie elementu jest niemożliwe: osiągnięto maksymalny poziom zagnieżdżenia.'), button.closest('.and-or-forms'));
        return;
    }
    var subform_type = button.data('add');
    var insert_before = button;
    // check the coupled input for subform type
    if (subform_type === 'switch') {
        subform_type = button.closest('.input-group').find('select').val();
        // nothing was chosen -> do nothing
        if (subform_type === '') {
            return;
        }
        var prefix = button.data('prefix');
        if (typeof prefix !== 'undefined') {
            subform_type = prefix + subform_type;
        }
        insert_before = button.closest('.form-group');
    }
    insert_subform(subform_type, function(form_html) {
        insert_before.before(form_html);
        var inserted = insert_before.prev();
        //inserted.addClass('border-left border-bottom border-dark py-1 pl-1 mb-1 ml-3 form-depth-' + depth);
        inserted.addClass('p-1 mb-1 ml-3 form-depth-' + depth);
        inserted.data('depth', depth)
        return inserted;
    });
}

function serialize_forms(element) {
    var children = [];
    element.children().each(function() {
        children = children.concat(serialize_forms($(this)));
    });
    var tag = element.tagName();
    if (tag === 'form') {
        var negated = [];
        element.children().children('.form-group.row').find('label.negated2').each(function() {
            negated.push($(this).attr('for').replace('id_', ''));
        });
        var ret = [];
        ret.push(JSON.stringify({'form' : element.serialize(), 'negated' : negated, 'formtype' : element.data('formtype'), 'formnumber' : element.data('formnumber'), 'children' : children}));
        return ret;
    } else if (element.hasClass('form-or')) {
        var ret = [];
        ret.push(JSON.stringify({'formtype' : 'or'}));
        return ret;
    } else if (element.hasClass('form-other')) {
        var ret = [];
        ret.push(JSON.stringify({'formtype' : 'other'}));
        return ret;
    } else if (element.hasClass('and-or-forms')) {
        return [JSON.stringify({'formtype' : element.data('formtype'), 'subforms' : children})];
    }
    else {
        return children;
    }
}

function initialize_form(form) {
    bind_form_events(form);
    form.data('depth', '0');
    form.find('input[type="reset"]').click(function(event) {
        // making sure the form is reset *before* resubmitting
        event.preventDefault();
        // in addition to resetting the form, remove all subforms and ors
        form.find('.subform').remove();
        form.find('.form-or').remove();
        form.find('.form-other').remove();
        // un-negate all attributes
        form.find('label').removeClass('negated2');
        form.trigger('reset');
        // and submit
        form.submit();
    });
}

function initialize_main_form() {
    
    var main_form = $('#main-form');
    
    initialize_form(main_form);
    
    //bind_form_events(main_form);
    
    //main_form.data('depth', '0');
    
    main_form.submit(function(event) {
        var submit = main_form.find('input[type="submit"]');
        submit.prop('disabled', true);
        event.preventDefault();
        // clear_results();
        clear_info();
        // show_entry_list_spinner();
        clear_form_errors(main_form);
        var data = { 'forms' : serialize_forms(main_form) };
        $.ajax({
            type     : 'post',
            url      : '/' + lang + '/entries/send_form/',
            dataType : 'json',
            data     : data,
            success  : function(response) {
                clear_info();
                if (response.errors) {
                    show_form_errors(main_form, response.errors);
                } else if (response.success) {
                    //ponizsza funkcja prowadzi do metody osadzonej w main.js, gdzie nastepuje odpowiednie odswiezenie komponentu z lista elementow Vue
                    update_entries();
                    $('#entry-filters').modal('hide');
                }
                submit.prop('disabled', false);
            },
            error: function(request, errorType, errorMessage) {
                show_error(errorType + ' (' + errorMessage + ')');
                submit.prop('disabled', false);
            }
        });
    });
    
    /*main_form.find('input[type="reset"]').click(function(event) {
        // making sure the form is reset *before* resubmitting
        event.preventDefault();
        // in addition to resetting the form, remove all subforms and ors
        main_form.find('.subform').remove();
        main_form.find('.form-or').remove();
        main_form.find('.form-other').remove();
        // un-negate all attributes
        main_form.find('label').removeClass('negated2');
        main_form.trigger('reset');
        // and submit
        main_form.submit();
    });*/
}

function initialize_local_form(selector, url) {
    
    var form = selector.find('form');
    
    initialize_form(form);
    
    form.submit(function(event) {
        var submit = form.find('input[type="submit"]');
        submit.prop('disabled', true);
        event.preventDefault();
        clear_form_errors(form);
        var data = { 'forms' : serialize_forms(form), 'entry' : curr_entry };
        $.ajax({
            type     : 'post',
            url      : url,
            dataType : 'json',
            data     : data,
            success  : function(response) {
                clear_info();
                if (response.errors) {
                    show_form_errors(form, response.errors);
                } else if (response.success) {
                    //ponizsza funkcja prowadzi do metody osadzonej w main.js, gdzie nastepuje odpowiednie odswiezenie komponentu z lista elementow Vue
                    update_entries();
                    selector.modal('hide');
                }
                submit.prop('disabled', false);
            },
            error: function(request, errorType, errorMessage) {
                show_error(errorType + ' (' + errorMessage + ')');
                submit.prop('disabled', false);
            }
        });
    });
    
}   

function initialize_frames_form() {
    initialize_local_form($('#frame-filters-local'), '/' + lang + '/entries/send_frames_form/');
}

function initialize_unified_frames_form() {
    initialize_local_form($('#unified-frame-filters'), '/' + lang + '/entries/send_unified_frames_form/');
}


function initialize_schemata_form() {

    initialize_local_form($('#schema-filters-local'), '/' + lang + '/entries/send_schemata_form/');
    
    /*var schemata_form = $('#schema-filters').find('form');
    
    initialize_form(schemata_form);
    
    schemata_form.submit(function(event) {
        var submit = schemata_form.find('input[type="submit"]');
        submit.prop('disabled', true);
        event.preventDefault();
        clear_form_errors(schemata_form);
        var data = { 'forms' : serialize_forms(schemata_form), 'entry' : curr_entry };
        $.ajax({
            type     : 'post',
            url      : '/' + lang + '/entries/send_schemata_form/',
            dataType : 'json',
            data     : data,
            success  : function(response) {
                clear_info();
                if (response.errors) {
                    show_form_errors(schemata_form, response.errors);
                } else if (response.success) {
                    get_entry(curr_entry);
                    $('#schema-filters').modal('hide');
                }
                submit.prop('disabled', false);
            },
            error: function(request, errorType, errorMessage) {
                show_error(errorType + ' (' + errorMessage + ')');
                submit.prop('disabled', false);
            }
        });
    });*/
    
}
