from django.urls import path

from . import autocompletes, views
from .views import ajax_plWN_context_lookup, ajax_predefined_preferences, ajax_relations, ajax_synsets, ajax_roles, \
    ajax_role_attributes

app_name = 'entries'

urlpatterns = [
    path('send_form/', views.send_form, name='send_form'),
    path('send_schemata_form/', views.send_schemata_form, name='send_schemata_form'),
    path('send_frames_form/', views.send_frames_form, name='send_frames_form'),
    #path('filter_schemata/', views.filter_schemata, name='filter_schemata'),
    path('get_entries/', views.get_entries, name='get_entries'),
    path('get_entry/', views.get_entry, name='get_entry'),
    path('get_subform/', views.get_subform, name='get_subform'),
    path('change_show_reals_desc/', views.change_show_reals_desc, name='change_show_reals_desc'),
    path('change_show_linked_entries/', views.change_show_linked_entries, name='change_show_linked_entries'),
    path('unification', views.unification, name='unification'),

    path('autocomplete/', autocompletes.autocomplete, name='autocomplete'),
    path('plWN_context_lookup/', ajax_plWN_context_lookup, name='plWN_context_lookup'),
    path('predefined_preferences/', ajax_predefined_preferences, name='predefined_preferences'),
    path('roles/', ajax_roles, name='roles'),
    path('role_attributes/', ajax_role_attributes, name='role_attributes'),
    path('relations/', ajax_relations, name='relations'),
    path('synsets/', ajax_synsets, name='synsets'),

    # TODO remove!
    #path('test/', views.test, name='test'),
    path('', views.entries, name='entries'),
]
