var predefined = [];
var relations = [];
var synsets = [];
var change = false;

function predefinedSelect() {
    let display = "";

    let i;
    for (i = 0; i < predefined.length; i++) {
        display += "<input type = \"checkbox\" name = \"predef\" value = \"" + predefined[i].id + "\">" + predefined[i].content + "<br>";
    }

    return display;
}

function getPredefinedSelections() {
    $.ajax({
        dataType: "json",
        url: 'predefined_preferences',
        success: function(data){
            predefined = data.predefined;
        },
        async: false
    });
}

function memorizeRelations(new_relations) {
    relations = new_relations;
}

function relationsSelect() {
    let display = "<select name = \"rel\">";

    let i;
    for (i = 0; i < relations.length; i++) {
        display += "<option value = \"" + relations[i].id + "\">" + relations[i].content + "</option>";
    }
    display += "</select>"
    return display;
}

function argumentSelect(frame, complement_id) {
    let display = "<select name = \"arg\">";

    let i;
    for (i = 0; i < frame.arguments.length; i++) {
        var local_complement_id = frame.arguments[i].argument_id;
        if (local_complement_id && local_complement_id !== String(complement_id)) {
            display += "<option value = \"" + local_complement_id + "\">" + frame.arguments[i].role + "</option>";
        }
    }

    display += "</select>"

    return display;
}

function getSynsets(context, pos) {

    if ((typeof pos) == 'undefined') {
        pos = '_';
    }

    $.ajax({
        dataType: "json",
        url: 'synsets',
        data: {base: context, pos: pos},
        success: function(data){ synsets = data.synsets },
        async: false
    });

    let display = "";

    let i;
    for (i = 0; i < synsets.length; i++) {
        display += "<input type = \"radio\" name = \"synset\" value = \"" + synsets[i].id + "\"><div>";
        let j;
        for (j = 0; j < synsets[i].content.length; j++) {
            const lexical_unit = synsets[i].content[j];
            display += lexical_unit.base + "-" + lexical_unit.sense + ": <i>" + lexical_unit.glossa + "</i><br>";
        }
        display += "</div>";
    }

    return display;

}

function relationArgument(frame, complement_id) {
    return relationsSelect() + "<br><br>" + argumentSelect(frame, complement_id);
}

function attachPlWNContextAutocomplete() {
    $('#plWN_context_selection').autocomplete({
        select: function(event, ui){
        },
        source: function(req, add){
            $.getJSON('plWN_context_lookup', req, function(data) {
                const suggestions = [];
                $.each(data['result'], function(i, val){
                    suggestions.push(val);
                });
                add(suggestions);
            });
        },
    });
}

function addSelectivePreference(unified_frame, unified_frame_active_argument_id, frames, callbackFunction) {
    if (!unified_frame_active_argument_id) return;
    addSelectivePreferenceBase(unified_frame, frames, unified_frame_active_argument_id, callbackFunction);
}

function addSelectivePreferenceBase(unified_frame, frames, complement_id, callbackFunction) {
    let unified_frame_id = unified_frame.id;

    const submitSynsetSelection = function(e,v,m,f){
        if (v == -1) {
            e.preventDefault();
            $.prompt.goToState('state2');
        }
        if (v == 1) {
            e.preventDefault();
            const synset = normalizeFormData(f.synset);

            let i;
            for (i = 0; i < synset.length; i++) {
                saveSynsetPreference(unified_frame_id, complement_id, synset[i])
            }
            $.prompt.goToState('state0');
        }
    }

    const existingSelect = function () {
        let availablePreferencies = slowal_frames2selecional_preferencies(unified_frame, frames)[complement_id];
        if (!availablePreferencies) {
            return gettext('Brak preferencji selekcyjnych do wyboru.')
        }
        return availablePreferencies.map(preference => {
            return `<label><input type="checkbox" name="existing" value="${preference.type}:${preference.id}" /> ${preference.str}</label><br />`;
        }).join("");
    };

    const select_preference = {
        state0: {
            title: 'Typ preferencji selekcyjnej',
            html: 'Wybierz typ preferencji selekcyjnej',
            buttons: { Istniejąca: 0, Predefiniowana: 1, Słowosieć: 2, Relacja: 3, Koniec: -1 },
            focus: -1,
            submit: function(e,v,m,f){
                if (v == -1) {
                    e.preventDefault();
                    $.prompt.close();

                    callbackFunction();
                }
                if (v === 0) {
                    e.preventDefault();
                    $.prompt.goToState('state4');
                }
                if (v == 1) {
                    e.preventDefault();
                    $.prompt.goToState('state1');
                }
                if (v == 2) {
                    e.preventDefault();
                    $.prompt.goToState('state2');
                }
                if (v == 3) {
                    e.preventDefault();
                    $.prompt.goToState('state3');
                }
            }
        },
        state1: {
            title: 'Wybierz preferencję selekcyjną',
            html: predefinedSelect(),
            buttons: { Anuluj: -1, Zatwierdź: 1 },
            focus: 1,
            submit: function(e,v,m,f){

                if (v == -1) {
                    e.preventDefault();
                    $.prompt.goToState('state0');
                }
                if (v == 1) {
                    e.preventDefault();
                    const predef = normalizeFormData(f.predef);

                    let i;
                    for (i = 0; i < predef.length; i++) {
                        savePredefinedPreference(unified_frame_id, complement_id, predef[i])
                        // addPreference(unified_frame_id, complement_id, { type: 'g', content: predef[i], text: predefined[indexOfId(predefined, predef[i])].content });
                    }
                    $.prompt.goToState('state0');
                }
            }
        },
        state2: {
            title: 'Wybierz preferencję selekcyjną',
            html: "<input id=\"plWN_context_selection\" type=\"text\" name=\"context\">",
            buttons: { Anuluj: -1, Wyszukaj: 1 },
            focus: 1,
            submit: function(e,v,m,f){
                if (v == -1) {
                    e.preventDefault();
                    $.prompt.goToState('state0');
                }
                if (v == 1) {
                    e.preventDefault();
                    $.prompt.removeState('state21');
                    $.prompt.addState('state21', {title: 'Znaczenia', html: getSynsets(f.context), buttons: {Anuluj: -1, Zatwierdź: 1}, focus: 1, submit: submitSynsetSelection}, 'state2');
                    $.prompt.goToState('state21');
                }
            }
        },
        state3: {
            title: 'Wybierz relację i argument',
            html: relationArgument(unified_frame, complement_id),
            buttons: { Anuluj: -1, Zatwierdź: 1 },
            focus: 1,
            submit: function(e,v,m,f){
                if (v == -1) {
                    e.preventDefault();
                    $.prompt.goToState('state0');
                }
                if (v == 1) {
                    e.preventDefault();

                    const rel = normalizeFormData(f.rel);
                    const args = normalizeFormData(f.arg);

                    let i, j;
                    for (i = 0; i < rel.length; i++) {
                        for (j = 0; j < args.length; j++) {
                            saveRelationalSelectionalPreference(unified_frame_id, complement_id, args[j], rel[i])
                            // addPreference(unified_frame_id, complement_id, {type: 'r', content: { relation: rel[i], to: args[j] }, text: relations[indexOfId(relations, rel[i])].content + "<br>-> [" + text + "]" });
                        }
                    }

                    $.prompt.goToState('state0');
                }
            }
        },
        state4: {
            title: 'Wybierz z istniejących',
            html: existingSelect(),
            buttons: { Anuluj: -1, Zatwierdź: 1 },
            focus: 1,
            submit: function(e,v,m,f){
                if (v == -1) {
                    e.preventDefault();
                    $.prompt.goToState('state0');
                }
                if (v == 1) {
                    e.preventDefault();
                    normalizeFormData(f.existing).map(choice => {
                        let [type, id] = choice.split(':');
                        switch (type) {
                            case 'meanings.Synset':
                                saveSynsetPreference(unified_frame_id, complement_id, id);
                            case 'semantics.PredefinedSelectionalPreference':
                                savePredefinedPreference(unified_frame_id, complement_id, id);
                            case 'semantics.RelationalSelectionalPreference':
                                saveRelationalSelectionalPreference(unified_frame_id, complement_id, null, null);  // TODO
                        }
                    });
                    $.prompt.goToState('state0');
                }
            }
        },
    };
    if (change == true) {
        alertSemantics();
    } else {
        $.prompt(select_preference);
        attachPlWNContextAutocomplete();
    }

}




function saveSynsetPreference(frame_id, complement_id, synset_preference_id) {
    const data = { 'frame_id' : frame_id, 'complement_id' : complement_id, 'synset_preference_id' : synset_preference_id };
    $.ajax({
        type     : 'post',
        url      : '/' + lang + '/unifier/save_synset_preference/',
        dataType : 'json',
        data     : data,
        timeout  : 60000,
        success  : function(response) {
            show_info('Preferencja zosała zapisana');
        },
        error: function(request, errorType, errorMessage) {
            show_error(errorType + ' (' + errorMessage + ')');
        }
    });
}

function savePredefinedPreference(frame_id, complement_id, predefined_preference_id) {
    const data = { 'frame_id' : frame_id, 'complement_id' : complement_id, 'predefined_preference_id' : predefined_preference_id };
    $.ajax({
        type     : 'post',
        url      : '/' + lang + '/unifier/save_predefined_preference/',
        dataType : 'json',
        data     : data,
        timeout  : 60000,
        success  : function(response) {
            show_info('Preferencja zosała zapisana');
        },
        error: function(request, errorType, errorMessage) {
            show_error(errorType + ' (' + errorMessage + ')');
        }
    });
}

function saveRelationalSelectionalPreference(frame_id, complement_id_from, complement_id_to, relation_id) {
    const data = { 'frame_id' : frame_id, 'complement_id_from' : complement_id_from, 'complement_id_to' : complement_id_to, 'relation_id': relation_id };
    $.ajax({
        type     : 'post',
        url      : '/' + lang + '/unifier/save_relational_selectional_preference/',
        dataType : 'json',
        data     : data,
        timeout  : 60000,
        success  : function(response) {
            show_info('Preferencja zosała zapisana');
        },
        error: function(request, errorType, errorMessage) {
            show_error(errorType + ' (' + errorMessage + ')');
        }
    });
}


